/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : ST7262 Interrupt vectors call table.
#
# HISTORY :
#								                                                              
******************************************************************************/
  
// Define interrupt service routines as external functions

//extern void _stext(); 		// -> use with startup file crts*.s
extern void DFU_Main();
extern void DFU_INT_Trap(); 
extern void DFU_INT_Flash();
extern void INT_EndSusp();
extern void DFU_INT_IT1IT4();
extern void DFU_INT_IT5IT8();
extern void DFU_INT_IT9IT12();
extern void DFU_INT_Tbu();
extern void DFU_INT_ArtPwmTimer();
extern void DFU_INT_Spi();
extern void DFU_INT_Sci();
extern void INT_Usb();
extern void DFU_INT_Adc();

// Assign ISR to interrupt vectors

#pragma section const {vector}

void (* const _vectab[])() = 
{          
	DFU_INT_Adc,
	INT_Usb,
	DFU_INT_Sci,  
	DFU_INT_Spi,
	DFU_INT_ArtPwmTimer,
	DFU_INT_Tbu,
	DFU_INT_IT9IT12,
	DFU_INT_IT5IT8,
	DFU_INT_IT1IT4,
	INT_EndSusp,
	DFU_INT_Flash,
	DFU_INT_Trap,
	DFU_Main              // FFFEh-FFFFh : reset vector    (or use _text with asm startup file)
};                     

/*** END OF FILE ***/