/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : ST7263B Interrupt vectors call table.
#
# HISTORY :
#								                                                              
******************************************************************************/
   
// Define interrupt service routines as external functions

//extern void _stext(); 		// -> use with startup file crts*.s
extern void DFU_Main();
extern void DFU_INT_Trap(); 
extern void INT_EndSusp();
extern void DFU_INT_IT1IT8();
extern void DFU_INT_Timer();
extern void DFU_INT_I2c();
extern void DFU_INT_Sci();
extern void INT_Usb();
extern void DFU_INT_Flash();

// Assign ISR to interrupt vectors

#pragma section const {vector}

void (* const _vectab[])() = 
{
	INT_Usb,
	DFU_INT_Sci,
	DFU_INT_I2c,
	DFU_INT_Timer,
	DFU_INT_IT1IT8,
	INT_EndSusp,
	DFU_INT_Flash,
	DFU_INT_Trap,            // FFFCh-FFFDh : Software interrupt 
	DFU_Main                 // FFFEh-FFFFh : reset vector    (or use _text with asm startup file)
};                     

/*** END OF FILE ***/