/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : Device Firmware Upgrade descriptor file header	 	
#				
# HISTORY :
#
******************************************************************************/   

#ifndef DFUDESCRIPT_H
#define DFUDESCRIPT_H

#include "USB_Opts.h"
#include "Lib_Bits.h"

#ifdef USE_DEVICE_FIRMWARE_UPGRADE 

#define DFU_DEVDESC_LEN		18		// Device desc length (Byte)         
#define DFU_CONFDESC_LEN	25		// Config desc length (Word)
#define DFU_MANUFSTR_LEN	 6		// Manufacturer string length (Byte)
#define DFU_LANGSTR_LEN	 	 4		// Language string length (Byte)
#define DFU_NAMESTR_LEN		 8		// Product name string length (Byte)
//#define DFU_SERIALSTR_LEN	10		// Serial number string length (Byte)
#define DFU_ADDSTR_LEN		 8		// Additional string length (Byte)

/****************************************************************************************/
/*			DESCRIPTORS FOR DEVICE FIRMWARE UPGRADE MODE	 (DFU)		*/	
/****************************************************************************************/

// Run-Time DFU Interface Descriptor (included in Normal Configuration Descriptor only)	
#define DFU_RNTM_INTERFACE_DESC \
	0x09, /* bLength : Size of this descriptor in bytes */ \
	0x04, /* bDescriptorType : Interface descriptor type */ \
	0x01, /* bInterfaceNumber : Interface Number = 1 */ \
	0x00, /* bAlternateSetting : No Alternate setting */ \
	0x00, /* bNumEndpoints : Only the Control pipe is used (EndPoint0) */ \
	0xFE, /* bInterfaceClass : Application Specific Class Code */ \
	0x01, /* bInterfaceSubClass : DFU Code */ \
	0x00, /* bInterfaceProtocol : none */ \
	0x00  /* iInterface : Index of String descriptor (none) */

//#define DFU_RNTM_INTERFACE_DESC 0x09,0x04,0x01,0,0,0xFE,0x01,0,0
	                                                                                                    
// Run-Time DFU Functional Descriptor (included in Normal and in DFU Mode Configuration Descriptors)
#define DFU_FUNCTIONAL_DESC \
	0x07, /* bLength : Size of this descriptor in bytes */ \
	0x21, /* bDescriptorType : DFU Functional descriptor type */ \
	0x03, /* bmAttributes : Device is NOT Manifestation tolerant, UpLoad and DownLoad capable */ \
	0x10, /* wDetachTimeOutL : 10ms to wait after receipt of DFU_DETACH request */ \
	0x00, /* wDetachTimeOutH */ \
	0x08, /* wTransferSizeL : 8 bytes max per control-write operation */ \
	0x00  /* wTransferSizeH */

//#define DFU_FUNCTIONAL_DESC 0x07,0x21,0x07,0x10,0,0x10,0

// DFU Mode Interface Descriptor (included in DFU Mode Configuration Descriptor only)	
#define DFU_INTERFACE_DESC \
	0x09, /* bLength : Size of this descriptor in bytes */ \
	0x04, /* bDescriptorType : Interface descriptor type */ \
	0x00, /* bInterfaceNumber : Interface Number is always 0 */ \
	0x00, /* bAlternateSetting : No Alternate setting */ \
	0x00, /* bNumEndpoints : Only the Control pipe is used (EndPoint0) */ \
	0xFE, /* bInterfaceClass : Application Specific Class Code */ \
	0x01, /* bInterfaceSubClass : DFU Code */ \
	0x00, /* bInterfaceProtocol : none */ \
	0x00  /* iInterface : Index of String descriptor (none) */

//#define DFU_INTERFACE_DESC 0x09,0x04,0,0,0,0xFE,0x01,0,0

#ifdef HIWARE
#pragma CONST_SEG DFU_DESC
#endif

extern const Byte DFU_Device_Desc[];
extern const Byte DFU_Config_Desc[];
extern const Byte DFU_Manuf_String[];
extern const Byte DFU_Lang_String[];
extern const Byte DFU_Name_String[];
//extern const Byte DFU_Serial_String[];
#ifdef USE_ADD_STRINGS
extern const Byte DFU_Add_String[];
#endif

#ifdef HIWARE
#pragma CONST_SEG DEFAULT
#endif

#endif // USE_DEVICE_FIRMWARE_UPGRADE    

#endif // DFUDESCRIPT_H

/*** END OF FILE ***/