/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : HDFlash Driver
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.0
#
# DESCRIPTION : Macros for HDFlash operations.
#						                                                              
******************************************************************************/

#ifndef HDFLASH_H
#define HDFLASH_H

// Used to launch call-back function during Embedded command TimeOut
//#define USE_TIMEOUT

#ifdef USE_TIMEOUT
extern void UserWhileErase(void);      // Call-back function
extern void UserWhileWriteBlock(void); // Call-back function
#endif

// Embedded Command Parameters
#define EMBLG_PARAM_FREQ (*(unsigned char *)0xF8)
#define EMBLG_PARAM_DATA (*(unsigned char *)0xF9)
#define EMBLG_PARAM_ENDH (*(unsigned char *)0xFA)
#define EMBLG_PARAM_ENDL (*(unsigned char *)0xFB)
#define EMBLG_PARAM_END  (*(unsigned char **)0xFA)
#define EMBLG_PARAM_PTRH (*(unsigned char *)0xFC)
#define EMBLG_PARAM_PTRL (*(unsigned char *)0xFD)
#define EMBLG_PARAM_PTR  (*(unsigned int  *)0xFC)
#define EMBLG_PARAM_SECT (*(unsigned char *)0xFE)
#define EMBLG_PARAM_ECMD (*(unsigned char *)0xFF)

// Embedded Command Return Status Codes
#define HDFLASH_BYTEPROG_OK   0x00
#define HDFLASH_BLOCKPROG_OK  0x01
#define HDFLASH_OPTIONPROG_OK 0x02
#define HDFLASH_ERASE_OK      0x03
#define HDFLASH_PROGALL_OK    0x04
#define HDFLASH_OPTIONREAD_OK 0x05
#define HDFLASH_CHECKSUM_OK   0x06
#define HDFLASH_BUSY          0x80

// Variables used by Application
#define HDFlashStatus EMBLG_PARAM_ECMD
#define CheckSumL     EMBLG_PARAM_ENDL
#define CheckSumH     EMBLG_PARAM_ENDH

// key1 = unsigned char, key2 = unsigned char
#define RASS_Disable(key1, key2) { \
 FCSR = key1; \
 FCSR = key2; }

// Sector = unsigned char, Freq = unsigned char
#ifdef USE_TIMEOUT
#define HDFlashEraseSector(Sector, Freq) { \
 EMBLG_PARAM_ECMD = 0x03; \
 EMBLG_PARAM_PTRL = 0x03; \
 EMBLG_PARAM_SECT = Sector; \
 EMBLG_PARAM_PTRH = Sector; \
 EMBLG_PARAM_FREQ = Freq; \
 do {FCSR = 0x00; UserWhileErase();} while (EMBLG_PARAM_ECMD & HDFLASH_BUSY); }
#else
#define HDFlashEraseSector(Sector, Freq) { \
 EMBLG_PARAM_ECMD = 0x03; \
 EMBLG_PARAM_PTRL = 0x03; \
 EMBLG_PARAM_SECT = Sector; \
 EMBLG_PARAM_PTRH = Sector; \
 EMBLG_PARAM_FREQ = Freq; \
 do {FCSR = 0x00;} while (EMBLG_PARAM_ECMD & HDFLASH_BUSY); }
#endif

// Data = unsigned char, Address = unsigned int, Freq = unsigned char
#define HDFlashWriteByte(Data, Address, Freq) { \
 EMBLG_PARAM_ECMD = 0x00; \
 EMBLG_PARAM_PTR  = Address; \
 EMBLG_PARAM_DATA = Data; \
 EMBLG_PARAM_FREQ = Freq; \
 FCSR = 0x00; }

// Buffer = unsigned char *, Address = unsigned int, ByteNb = unsigned char, Freq = unsigned char
#ifdef USE_TIMEOUT
#define HDFlashWriteBlock(Buffer, Address, ByteNb, Freq) { \
 EMBLG_PARAM_ECMD = 0x01; \
 EMBLG_PARAM_SECT = ByteNb; \
 EMBLG_PARAM_PTR  = Address; \
 EMBLG_PARAM_END  = Buffer; \
 EMBLG_PARAM_FREQ = Freq; \
 do {FCSR = 0x00; UserWhileWriteBlock();} while (EMBLG_PARAM_ECMD & HDFLASH_BUSY); }
#else
#define HDFlashWriteBlock(Buffer, Address, ByteNb, Freq) { \
 EMBLG_PARAM_ECMD = 0x01; \
 EMBLG_PARAM_SECT = ByteNb; \
 EMBLG_PARAM_PTR  = Address; \
 EMBLG_PARAM_END  = Buffer; \
 EMBLG_PARAM_FREQ = Freq; \
 do {FCSR = 0x00;} while (EMBLG_PARAM_ECMD & HDFLASH_BUSY); }
#endif
 
// Freq = unsigned char
#define HDFlashProgAll(Freq) { \
 EMBLG_PARAM_ECMD = 0x04; \
 EMBLG_PARAM_PTRL = 0x00; \
 EMBLG_PARAM_PTRH = 0x04; \
 EMBLG_PARAM_ENDL = 0xFF; \
 EMBLG_PARAM_ENDH = 0xFF; \
 EMBLG_PARAM_DATA = 0x00; \
 EMBLG_PARAM_FREQ = Freq; \
 FCSR = 0x00; }

// Opt0 = unsigned char, Opt1 = unsigned char, Freq = unsigned char 
#define HDFlashWriteOptByte(Opt0, Opt1, Freq) { \
 EMBLG_PARAM_ECMD = 0x02; \
 EMBLG_PARAM_PTRL = 0x20; \
 EMBLG_PARAM_ENDL = 0x38; \
 EMBLG_PARAM_ENDH = Opt1; \
 EMBLG_PARAM_DATA = Opt0; \
 EMBLG_PARAM_FREQ = Freq; \
 FCSR = 0x00; }

// Freq = unsigned char
#define HDFlashReadOptByte(Freq) { \
 EMBLG_PARAM_ECMD = 0x05; \
 EMBLG_PARAM_FREQ = Freq; \
 FCSR = 0x00; }

// Address = unsigned int, Freq = unsigned char
#define HDFlashChecksum(Address, Freq) { \
  EMBLG_PARAM_ECMD = 0x06; \
  EMBLG_PARAM_PTR  = Address; \
  EMBLG_PARAM_FREQ = Freq; \
  FCSR = 0x00; }

#endif

/*** END OF FILE ***/