/*** (c) STMicroelectronics ***************************************************
#
# COMPILER : COSMIC / HIWARE
#
# DESCRIPTION : Macro definitions 
#								                                                              
******************************************************************************/
   
#ifndef MACRO_H
#define MACRO_H

#ifdef HIWARE
#include "Hidef.h"
#endif

#define max(a,b)		(((a) > (b)) ? (a) : (b))
#define min(a,b)		(((a) < (b)) ? (a) : (b))

#define MAKEWORD(msb, lsb)      ((Word)(((Word)((Byte)(msb))) << 8) | ((Byte)(lsb)))
#define MAKELONG(msw, lsw)	((LWord)(((Word)(lsw)) | ((LWord)((Word)(msw))) << 16))
#define LOWORD(l)		((Word)(l))
#define HIWORD(l)		((Word)(((LWord)(l) >> 16) & 0xFFFF))
#define LOBYTE(w)		((Byte)(w))
#define HIBYTE(w)		((Byte)(((Word)(w) >> 8) & 0xFF))

#endif // MACRO_H

/*** END OF FILE ***/