/*** (c) STMicroelectronics ***************************************************
#
# COMPILER : COSMIC / HIWARE
#
# DESCRIPTION : Register mapping header file for ST7263B
#
******************************************************************************/

#ifndef MAP_7263B_H
#define MAP_7263B_H

/* PORTA REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTA
#endif

extern volatile unsigned char PADR;
extern volatile unsigned char PADDR;

/* PORTB REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTB
#endif

extern volatile unsigned char PBDR;
extern volatile unsigned char PBDDR;

/* PORTC REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTC
#endif

extern volatile unsigned char PCDR;
extern volatile unsigned char PCDDR;

/* INTERRUPT REGISTER */

#ifdef HIWARE
#pragma DATA_SEG SHORT EXT_INT
#endif

extern volatile unsigned char ITRFRE; 

/* MISCELLANEOUS REGISTER */

#ifdef HIWARE
#pragma DATA_SEG SHORT MISCR
#endif

extern volatile unsigned char MISCR;

/* ADC REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT ADC
#endif

extern volatile unsigned char ADCDR;
extern volatile unsigned char ADCCSR;

/* WATCHDOG REGISTER */

#ifdef HIWARE
#pragma DATA_SEG SHORT WATCHDOG
#endif

extern volatile unsigned char WDGCR;

/* TIMER REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT TIMER
#endif

extern volatile unsigned char TIMCR2;
extern volatile unsigned char TIMCR1;
extern volatile unsigned char TIMSR;
extern volatile unsigned char TIMIC1HR;
extern volatile unsigned char TIMIC1LR;
extern volatile unsigned char TIMOC1HR;
extern volatile unsigned char TIMOC1LR;
extern volatile unsigned char TIMCHR;
extern volatile unsigned char TIMCLR;
extern volatile unsigned char TIMACHR;
extern volatile unsigned char TIMACLR;
extern volatile unsigned char TIMIC2HR;
extern volatile unsigned char TIMIC2LR;
extern volatile unsigned char TIMOC2HR;
extern volatile unsigned char TIMOC2LR;

/* SCI REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT SCI
#endif

extern volatile unsigned char SCISR;
extern volatile unsigned char SCIDR;
extern volatile unsigned char SCIBRR;
extern volatile unsigned char SCICR1;
extern volatile unsigned char SCICR2;

/* USB REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT USB
#endif

extern volatile unsigned char USBPIDR;
extern volatile unsigned char USBDMAR;
extern volatile unsigned char USBIDR;
extern volatile unsigned char USBISTR;
extern volatile unsigned char USBIMR;
extern volatile unsigned char USBCTLR;
extern volatile unsigned char USBDADDR;
extern volatile unsigned char USBEP0RA;
extern volatile unsigned char USBEP0RB;
extern volatile unsigned char USBEP1RA;
extern volatile unsigned char USBEP1RB;
extern volatile unsigned char USBEP2RA;
extern volatile unsigned char USBEP2RB;

/* FLASH REGISTER */

#ifdef HIWARE
#pragma DATA_SEG SHORT FLASH
#endif

extern volatile unsigned char FCSR;

/* I2C REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT I2C
#endif

extern volatile unsigned char I2CDR;
extern volatile unsigned char I2C_RESERVED;
extern volatile unsigned char I2COAR;
extern volatile unsigned char I2CCCR;
extern volatile unsigned char I2CSR2;
extern volatile unsigned char I2CSR1;
extern volatile unsigned char I2CCR;

/* USB ENDPOINT BUFFERS */

#ifdef HIWARE
#pragma DATA_SEG DMA_CTRL
#endif

extern unsigned char EP0OutBuffer[8];
extern unsigned char EP0InBuffer[8];

#ifdef HIWARE
#pragma DATA_SEG DMA_OUT1
#endif

extern unsigned char EP1OutBuffer[8];

#ifdef HIWARE
#pragma DATA_SEG DMA_IN1
#endif

extern unsigned char EP1InBuffer[8];

#ifdef HIWARE
#pragma DATA_SEG DMA_OUT2
#endif

extern unsigned char EP2OutBuffer[8];

#ifdef HIWARE
#pragma DATA_SEG DMA_IN2
#endif

extern unsigned char EP2InBuffer[8];

#ifdef HIWARE
#pragma DATA_SEG DEFAULT
#endif

#endif // MAP_7263B_H

/*** END OF FILE ***/