/*** (c) STMicroelectronics ***************************************************
#
# COMPILER : COSMIC / HIWARE
#
# DESCRIPTION : Register mapping for ST7263 16K
#
******************************************************************************/

#ifdef HIWARE
#include "Map_7263_16K.h"
#endif

/* PORTA REGISTERS */

#ifdef COSMIC
volatile unsigned char PADR @0x00;
volatile unsigned char PADDR @0x01;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTA
volatile unsigned char PADR;
volatile unsigned char PADDR;
#endif

/* PORTB REGISTERS */

#ifdef COSMIC
volatile unsigned char PBDR @0x02;
volatile unsigned char PBDDR @0x03;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTB
volatile unsigned char PBDR;
volatile unsigned char PBDDR;
#endif

/* PORTC REGISTERS */

#ifdef COSMIC
volatile unsigned char PCDR @0x04;
volatile unsigned char PCDDR @0x05;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTC
volatile unsigned char PCDR;
volatile unsigned char PCDDR;
#endif

/* INTERRUPT REGISTER */

#ifdef COSMIC
volatile unsigned char ITRFRE @0x08;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT EXT_INT
volatile unsigned char ITRFRE; 
#endif

/* MISCELLANEOUS REGISTER */

#ifdef COSMIC
volatile unsigned char MISCR @0x09;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT MISCR
volatile unsigned char MISCR;
#endif

/* ADC REGISTERS */

#ifdef COSMIC
volatile unsigned char ADCDR @0x0A;
volatile unsigned char ADCCSR @0x0B;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT ADC
volatile unsigned char ADCDR;
volatile unsigned char ADCCSR;
#endif

/* WATCHDOG REGISTER */

#ifdef COSMIC
volatile unsigned char WDGCR @0x0C;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT WATCHDOG
volatile unsigned char WDGCR;
#endif

/* TIMER REGISTERS */

#ifdef COSMIC
volatile unsigned char TIMCR2 @0x11;
volatile unsigned char TIMCR1 @0x12;
volatile unsigned char TIMSR @0x13;
volatile unsigned char TIMIC1HR @0x14;
volatile unsigned char TIMIC1LR @0x15;
volatile unsigned char TIMOC1HR @0x16;
volatile unsigned char TIMOC1LR @0x17;
volatile unsigned char TIMCHR @0x18;
volatile unsigned char TIMCLR @0x19;
volatile unsigned char TIMACHR @0x1A;
volatile unsigned char TIMACLR @0x1B;
volatile unsigned char TIMIC2HR @0x1C;
volatile unsigned char TIMIC2LR @0x1D;
volatile unsigned char TIMOC2HR @0x1E;
volatile unsigned char TIMOC2LR @0x1F;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT TIMER
volatile unsigned char TIMCR2;
volatile unsigned char TIMCR1;
volatile unsigned char TIMSR;
volatile unsigned char TIMIC1HR;
volatile unsigned char TIMIC1LR;
volatile unsigned char TIMOC1HR;
volatile unsigned char TIMOC1LR;
volatile unsigned char TIMCHR;
volatile unsigned char TIMCLR;
volatile unsigned char TIMACHR;
volatile unsigned char TIMACLR;
volatile unsigned char TIMIC2HR;
volatile unsigned char TIMIC2LR;
volatile unsigned char TIMOC2HR;
volatile unsigned char TIMOC2LR;
#endif

/* SCI REGISTERS */

#ifdef COSMIC
volatile unsigned char SCISR @0x20;
volatile unsigned char SCIDR @0x21;
volatile unsigned char SCIBRR @0x22;
volatile unsigned char SCICR1 @0x23;
volatile unsigned char SCICR2 @0x24;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT SCI
volatile unsigned char SCISR;
volatile unsigned char SCIDR;
volatile unsigned char SCIBRR;
volatile unsigned char SCICR1;
volatile unsigned char SCICR2;
#endif

/* USB REGISTERS */

#ifdef COSMIC
volatile unsigned char USBPIDR @0x25;
volatile unsigned char USBDMAR @0x26;
volatile unsigned char USBIDR @0x27;
volatile unsigned char USBISTR @0x28;
volatile unsigned char USBIMR @0x29;
volatile unsigned char USBCTLR @0x2A;
volatile unsigned char USBDADDR @0x2B;
volatile unsigned char USBEP0RA @0x2C;
volatile unsigned char USBEP0RB @0x2D;
volatile unsigned char USBEP1RA @0x2E;
volatile unsigned char USBEP1RB @0x2F;
volatile unsigned char USBEP2RA @0x30;
volatile unsigned char USBEP2RB @0x31;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT USB
volatile unsigned char USBPIDR;
volatile unsigned char USBDMAR;
volatile unsigned char USBIDR;
volatile unsigned char USBISTR;
volatile unsigned char USBIMR;
volatile unsigned char USBCTLR;
volatile unsigned char USBDADDR;
volatile unsigned char USBEP0RA;
volatile unsigned char USBEP0RB;
volatile unsigned char USBEP1RA;
volatile unsigned char USBEP1RB;
volatile unsigned char USBEP2RA;
volatile unsigned char USBEP2RB;
#endif

/* I2C REGISTERS */

#ifdef COSMIC
volatile unsigned char I2CDR @0x39;
volatile unsigned char I2C_RESERVED @0x3A;
volatile unsigned char I2COAR @0x3B;
volatile unsigned char I2CCCR @0x3C;
volatile unsigned char I2CSR2 @0x3D;
volatile unsigned char I2CSR1 @0x3E;
volatile unsigned char I2CCR @0x3F;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT I2C
volatile unsigned char I2CDR;
volatile unsigned char I2C_RESERVED;
volatile unsigned char I2COAR;
volatile unsigned char I2CCCR;
volatile unsigned char I2CSR2;
volatile unsigned char I2CSR1;
volatile unsigned char I2CCR;
#endif

/* USB ENDPOINT BUFFERS */

#ifdef COSMIC
unsigned char EP0OutBuffer[8] @0x140;
unsigned char EP0InBuffer[8] @0x148;
unsigned char EP1OutBuffer[8] @0x150;
unsigned char EP1InBuffer[8] @0x158;
unsigned char EP2OutBuffer[8] @0x160;
unsigned char EP2InBuffer[8] @0x168;
#endif

#ifdef HIWARE
#pragma DATA_SEG DMA_CTRL
unsigned char EP0OutBuffer[8];
unsigned char EP0InBuffer[8];
#pragma DATA_SEG DMA_OUT1
unsigned char EP1OutBuffer[8];
#pragma DATA_SEG DMA_IN1
unsigned char EP1InBuffer[8];
#pragma DATA_SEG DMA_OUT2
unsigned char EP2OutBuffer[8];
#pragma DATA_SEG DMA_IN2
unsigned char EP2InBuffer[8];
#endif

#ifdef HIWARE
#pragma DATA_SEG DEFAULT
#endif

/*** END OF FILE ***/