/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED LIBRARY
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 4.21
#
# DESCRIPTION : USB lib  aliasses
#
# HISTORY : 08/24/00 -> Added USB_REMOTE_WAKEUP_ENABLE flag in USBLibStatus to inform app about the RWU state
#
******************************************************************************/   

#ifndef USB_DEF_H
#define USB_DEF_H

#include "USB_Opts.h"
#include "Lib_Bits.h"
     
/********************************************************************************/
/*			Constants and aliases exposed to the application code layer		  	*/
/*							-- DO NOT MODIFY --									*/	
/********************************************************************************/

// String descriptors indexes
#define INDEX_MANUFACTURER		3  	// index of manufacturer string used by the library
#define INDEX_NAME			1  	// index of product name string used by the library
#define INDEX_ADD_STRING		4 	// index of additional string (optional) used by the library

#ifdef	USE_SERIAL_NUMBER
#define INDEX_SERIALNUM			2 	// index of serial number string used by the library		
#else
#define INDEX_SERIALNUM			0	// index =0 means serial number string not supported
#endif

// USBLibStatus selector
#define PRODUCT1			0x01	// always defined

#ifdef USE_PRODUCT2
#define PRODUCT2			0x02	// alternate product
#endif

#ifdef USE_DEVICE_FIRMWARE_UPGRADE
#define DFU_MODE			0x04	// DFU code loader device
#endif

#define APP_REQUEST			0x08	// Set by library when a non standard request has been received on Endpoint0
													// Clear by application code when processing of the request is done
#define USB_STALL			0x10	// Set by application code to stall a non standard request
													// Clear by library
#define USB_SUSPEND			0x20	// Set by library when suspend mode is requested
													// Clear by library when suspend is over
#define USB_REMOTE_WAKEUP_ENABLE	0x40	// Set by library when host enables the Remote Wakeup (default=disable)
													// Clear by library when host disables the Remote Wakeup
#define USB_CONFIGURED			0x80	// Set by library when host configures the peripheral

// USBLibStatus2 selector
#ifdef USE_DEVICE_FIRMWARE_UPGRADE
#define DFU_DETACH_RECEIVED		0x01													// Clear by library when host unconfigures the peripheral
#endif

// Endpoint direction selector
#define EP_IN				0x80
#define EP_OUT				0x00

// RequestType selector
#define TYPE                  		0x60
#define STANDARD              		0x00
#define CLASS                 		0x20
#define VENDOR                		0x40

/********************************************************************************/
/*	Library Variables exposed to the application code layer		  	*/	
/********************************************************************************/

/* USBTransferStatus specifies the current Control Transfer transaction stages :
  ------------------------------------------------------------------
  |     Phase name       | Value |            Description       
  ------------------------------------------------------------------
  |
  | NO_DATA_STAGE        | 0x01 | Control Transfer with IN data phase          
  |                             |                                  
  | DATA_STAGE_IN        | 0x02 | Control Transfer with IN data phase         
  |                             |                                     
  | DATA_STAGE_OUT	 | 0x04 | Control Transfer with OUT data phase   
  |                             |                                        
  | ONE_MORE		 | 0x08 | Following transaction will be either an Empty IN or a STATUS OUT.	
  |                             |   
  | ADDRESS2SET		 | 0x10 | Device address must be written after completion of Status Stage                  
  ------------------------------------------------------------------ */

#ifdef HIWARE
#define NEARCODE
#ifdef USE_DEVICE_FIRMWARE_UPGRADE
#pragma DATA_SEG DEFAULT
#else
#pragma DATA_SEG SHORT MY_RAM0
#endif
#endif

#ifdef COSMIC
#ifdef USE_DEVICE_FIRMWARE_UPGRADE
#define NEARCODE @near
#else
#define NEARCODE
#endif
#endif

extern NEARCODE Byte USBLibStatus;			// Used to exchange USB status with application
extern NEARCODE Byte USBTransferStatus;
// REM: the following variables are exposed to the application code to facilitate 
// the SETUP token decoding in the Handle_APP_Requests() function.
extern NEARCODE Byte USBbmRequestType;	// refer to USB spec ver 1.1, chap 9.3,  page 183
extern NEARCODE Byte USBbRequest;	// refer to USB spec ver 1.1, chap 9.3,  page 183
extern NEARCODE Byte USBwValue[2];	// refer to USB spec ver 1.1, chap 9.3,  page 183
extern NEARCODE Word USBwIndex;		// refer to USB spec ver 1.1, chap 9.3,  page 183
extern NEARCODE Word USBwLength;		// refer to USB spec ver 1.1, chap 9.3,  page 183

extern NEARCODE Byte USBDataXferStatus; // Used for sending/receiving more than 8 data
                                     // Values are : FIRST_DATA (init value) and LAST_DATA
                               
#ifdef USE_DEVICE_FIRMWARE_UPGRADE

extern NEARCODE Byte USBLibStatus2;

typedef struct {
  Byte EndPoint;
  Byte *Buffer;
  Byte Length;
} TWEPBParams;

typedef struct {
  Byte EndPoint;
  Byte *Buffer;
} TREPBParams;

typedef struct {
  Byte EndPoint;
  Byte Direction;
  Byte Length;
} TSEPRParams;

typedef union {
  TWEPBParams WEPBParams;  
  TREPBParams REPBParams;
  TSEPRParams SEPRParams;
} TParams;

extern NEARCODE TParams GParams;

#endif

#ifdef HIWARE
#pragma DATA_SEG DEFAULT
#endif

#endif // USB_DEF_H

/*** END OF FILE	***/