/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : Interrupt functions for ST7263B.
#               USB interrupt service routines are in USB_Rc.c file.
#
# HISTORY :
#								                                                              
******************************************************************************/

#include "USB_Opts.h"
#include "User_Def.h"
#include "Macro.h" 
#include "USB_Def.h"
#include "Lib_Bits.h"
#include "USB_Var.h"
#include "User_Var.h"
#include "USB_Lib.h"
#include "USB.h"

#ifdef HIWARE
#include MAP_FILE
#pragma CODE_SEG USER_ROM
#endif

/* ************************ INTERRUPT FUNCTIONS *******************************/

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Flash
DESCRIPTION  : Flash start programming
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Flash(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Flash(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Trap
DESCRIPTION  : TRAP interrupt routine.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Trap(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Trap(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_IT1IT8
DESCRIPTION  : External Interrupts. Used for Remote WakeUp (SW2 on PA4 = IT1) 
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_IT1IT8(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC SAVE_REGS
void INT_IT1IT8(void)
#endif
{
#ifdef USE_USB_REMOTE_WAKE_UP
	if ((USBLibStatus & USB_REMOTE_WAKEUP_ENABLE) && (USBLibStatus & USB_SUSPEND))
	{
		Do_USB_RemoteWU();
		MCU_Init();
	}
#endif
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Timer
DESCRIPTION  : Comes from the Timer cell
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Timer(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Timer(void)
#endif
{                               
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_I2c
DESCRIPTION  : Comes from the I2C cell.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_I2c(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_I2c(void)
#endif
{ 
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Sci
DESCRIPTION  : SCI Interrupt routine.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Sci(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Sci(void)
#endif
{
}

#ifdef HIWARE
#pragma CODE_SEG DEFAULT
#endif

/*** END OF FILE ***/