/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : Entry file.
#
# HISTORY :
#								                                                              
******************************************************************************/

#include "Main.h"
#include "Applet.h"  
#include "USB_App.h"
#include "USB_Opts.h"
#include "Lib_Bits.h"
#include "Macro.h"
#include "USB_Def.h"
#include "USB_Var.h"
#include "My_Init.h"
#include "HIDLayer.h"
#include "USB_Lib.h"
#include "User_Def.h"
#include "User_Var.h"

#ifdef USE_DEVICE_FIRMWARE_UPGRADE
#include "DFULibFuncAdd.h"
#endif

#ifdef HIWARE
#include MAP_FILE
#pragma CODE_SEG USER_ROM
#endif

/*-----------------------------------------------------------------------------
ROUTINE NAME : main
INPUT/OUTPUT : None
DESCRIPTION  : The reset vector points on main().
-----------------------------------------------------------------------------*/     
void main(void)
{          
/**************		Initialization section		********************/
                        
	/* Application init */
	Init_App_HW();			// Call user init routine

	// !!REM: USBLibStatus must be initialized prior to call Init_USB_HW()

#ifndef SELF_POWERED
	/* USB init */
	Init_USB_HW();          // Call USB init routine -> switch on USB cell = connect to PC
	                        // REM: Init_USB_HW() may be called anytime
#endif

	EnableInterrupts;
                
/**************		Main loop section		********************/
	while(1)
	{// main loop  
		 
#ifdef SELF_POWERED
		if (ValBit(PBDR,5)) // Not used in StarterKit
		{// Is Vbus present ?
			if (ValBit(USBCTLR,2))
			{ // if USB cell is OFF  --> Switch it ON
				Init_USB_HW();
			}   
		}
		else if (!(ValBit(USBCTLR,2)))
			{ // Vbus=0 and USB cell is ON  --> Switch it OFF
				Disable_USB_HW();
			}   
#endif

/**	Start of USB EP0 management section ******/
		if (USBLibStatus & USB_SUSPEND)
		{// We are in USB suspend !
			StopConsumption(); // Stop MCU consumption before entering in Halt mode.
#ifdef COSMIC
			_asm ("halt");
#endif
#ifdef HIWARE
			asm halt;
#endif
                  // If an external interrupt is used to perform a Remote Wake up,
	     		// then call the Do_USB_RemoteWU() function in the ext. int. ISR,
	     		// or use the combination of Start_USB_RemoteWU() & Stop_USB_RemoteWU()
		}
		else
		{        
			 	  		 
			 Handle_USB_Events();	            // Process USB Flow and STANDARD requests on EP0
		
			 if (USBLibStatus & APP_REQUEST)
			 {
			    Handle_APP_Requests();			// Process CLASS and VENDOR requests on EP0
			    Enable_STATUS_Stage();			// Enable ACKing/STALLing STATUS Stage according to USBLibStatus
			 }
		  	 		  	 
                 	 if (((Test_EP_Ready(0, EP_IN))||(Test_EP_Ready(0, EP_OUT))) && (USBDataXferStatus == LAST_DATA)) { // End of transfer
		  	   USBDataXferStatus = FIRST_DATA; // Reset flag for next data xfer
		  	   USBLibStatus &= ~APP_REQUEST; // END OF REQUEST
		  	 }
	  		 		  	 	
		}
/**	End of USB EP0 management section ******/

/**	Following section handles transfer on EP1 & EP2  ******/
	
		if (USBLibStatus & USB_CONFIGURED)
		{// REM: MUST BE CONFIGURED TO START REPORTING APPLICATION DATA
          
          IN_tempo++;

          if (IN_tempo == 500) {
#ifdef USE_REPORT5
            IN_SendReport5ToPC();
#else            
            Read_ADC();
#endif
            IN_tempo = 0;
          }
          else Read_BUTTON();

		  if (Applet_Data_Ready) { // Some data are ready to be sent
            if (Test_EP_Ready(1, EP_IN)) { // Test if EP1 is Ready to send data
		      Write_EP_Buffer(1, Applet_DataToSend, IN_NbBytesToSend);
	  	      Set_EP_Ready(1, EP_IN, IN_NbBytesToSend);
  		      Applet_Data_Ready = FALSE;
		    }		    
		  } 

#ifdef	USE_ENDPOINT2_OUT
		  if (Test_EP_Ready(2, EP_OUT))	// Test if data have been actually received on EP2.
		  {// REM: At this stage, EP2 Rx EndPoint was set to NAK by HW -> All extra OUT tokens are NACKed.

			Read_EP_Buffer(2, Applet_DataReceived);	// Store received data into DemoKit_Rep_OUT array.

			switch (Applet_DataReceived[0])			// Select Report ID Number
			{
			  case 1:		Command_LED();				// Set LED value
						break;
			  case 4:		Command_PWM();				// Set PWM value
						break;
			}

			Set_EP_Ready(2, EP_OUT, 0);			// Enable Acknowledge of next OUT Transfer on EP2. 

		  } /* EP2 OUT Ready*/	
#endif
		} /* USB CONFIGURED */
				    
		/*****	End of USB EP1/2 management section ******/		

	} // End main loop
}// End of main() (entry function)

#ifdef HIWARE
#pragma CODE_SEG DEFAULT
#endif

/*** END OF FILE ***/