/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION :
#  Contains "Handle_APP_Requests()" as well as build reports functions.
#  This file is given as an example . It is not part of the USB lib.
#  The functions of the example appli are;
#   - Read and send to host a push button state
#   - Receive from host a led state, then command led accordingly
#
# HISTORY :
#								                                                              
******************************************************************************/

#include "USB_App.h"
#include "HIDLayer.h"
#include "USB_Var.h"
#include "USB_Opts.h"
#include "USB_Def.h"
#include "My_Init.h"
#include "Lib_Bits.h"
#include "USB_Lib.h"
#include "User_Def.h"
#include "User_Var.h"

#ifdef USE_DEVICE_FIRMWARE_UPGRADE
#include "DFUCore.h"
#endif

#ifdef HIWARE
#include MAP_FILE
#pragma CODE_SEG USER_ROM
#endif

/*-----------------------------------------------------------------------------
ROUTINE NAME : Handle_APP_Requests
INPUT/OUTPUT : None
DESCRIPTION  : Process Vendor and Class specific requests
-----------------------------------------------------------------------------*/     
void Handle_APP_Requests(void)
{
/************************************************************************************************* 
!! IMPORTANT !!                                                                      
---------------
** The APP_REQUEST flag is set in USBLibStatus after decoding of the SETUP token for 
** a NO_DATA_STAGE or DATA_STAGE_IN  NON STANDARD request, and after acknoledge of the first OUT token 
** for a DATA_STAGE_OUT NON STANDARD request.

** REM : USBwValue[0], USBwValue[1], USBwIndex, USBwLength  are USB lib variables updated when a SETUP token is received
**       They are used in this function to facilitate SETUP decoding.
*************************************************************************************************/

	switch (USBbmRequestType & TYPE)
	{
#ifdef USE_VENDOR_REQUESTS
	case VENDOR:
		// Process your Vendor requests here
		/********** Example code *************/     
		/* SETUP fields are already saved into 	USBbmRequestType, USBbRequest, USBwValue[0], USBwValue[1], USBwIndex, USBwLength
			-> You may use them */ 
		if (USBTransferStatus & NO_DATA_STAGE)
		{
			// Decode SETUP  here, using Lib variables: 
			// USBbmRequestType, USBbRequest, USBwValue[0], USBwValue[1], USBwIndex, USBwLength 
		}
		else if (USBTransferStatus & DATA_STAGE_OUT)
		{
			// Decode SETUP  here, using Lib variables: 
			// USBbmRequestType, USBbRequest, USBwValue[0], USBwValue[1], USBwIndex, USBwLength 
			Read_EP_Buffer(0, 'your out buffer');	// Store Data received on EP0 into 'your buffer'
			// process data stage out vendor request here ...
			//...
		}
		else if (USBTransferStatus & DATA_STAGE_IN)
		{
			// Decode SETUP  here, using Lib variables: 
			// USBbmRequestType, USBbRequest, USBwValue[0], USBwValue[1], USBwIndex, USBwLength 
			Write_EP_Buffer(0, 'your in buffer', wLength); // Load Data to report into DMA buffer.
			Set_EP_Ready(0,EP_IN,wLength); // Prepare HW to send report IN to Host
		}
		USBLibStatus &= ~APP_REQUEST;	// Clear APP_REQUEST flag if data stage is over.
		return;
#endif
	case CLASS:		// CLASS specific request 
#ifdef USE_DEVICE_FIRMWARE_UPGRADE
	  if ((USBbRequest == DFU_DETACH) && (USBwIndex == 1)) { // DFU is the Interface #1
        USBLibStatus2 |= DFU_DETACH_RECEIVED; // To memorize that a DETACH has been received
        USBLibStatus &= ~APP_REQUEST;
        return;
      }
#endif
		Handle_HID_Requests();
	} // End of Request Type decoding section 

	/* !!! REM: Enable_STATUS_Stage() will take care of the Status Stage */
}

#ifdef USE_DEVICE_FIRMWARE_UPGRADE
/*-----------------------------------------------------------------------------
ROUTINE NAME : ReplugDevice
INPUT/OUTPUT : None
DESCRIPTION  : Used to simulate a device unplug-replug for re-enumeration.
-----------------------------------------------------------------------------*/
void ReplugDevice(void)
{

    // loop1 : 256 x 6 cyc = 1536 cyc
    // Duration : 0.4ms @ 4MHz, 0.2ms @ 8MHz

    // loop2 : 256 x 1542 cyc = 394752 cyc
    // Duration : 98ms @ 4MHz, 49ms @ 8MHz

    // loop3 : Y x 394759 cyc 
    // Duration for Y=10 : 1sec @ 4MHz, 0.5sec @ 8MHz

	#asm
		LD		Y, #10;
		CLR		X;
		CLR		A;
delay1:	INC		A;
		JRNE	delay1;
		INC		X;
		JRNE	delay1;
		DEC		Y;
		JRNE	delay1;
	#endasm

	USBCTLR |= 0x04; // Power-off 3.3V regulator

	#asm
		LD		Y, #10;
		CLR		X;
		CLR		A;
delay2:	INC		A;
		JRNE	delay2;
		INC		X;
		JRNE	delay2;
		DEC		Y;
		JRNE	delay2;
	#endasm

	USBCTLR &= ~0x04; // Power-on 3.3V regulator again
    
    // Tempo to wait USB regulator stabilization
	#asm
		CLR		A;
delay3:	INC		A;
		JRNE	delay3;
    #endasm

}
#endif

/*-----------------------------------------------------------------------------
ROUTINE NAME : Appli_Status_In
INPUT/OUTPUT : None
DESCRIPTION  : Called by User_Status_In when a Status IN is received
-----------------------------------------------------------------------------*/
void Appli_Status_In(void) {
#ifdef USE_DEVICE_FIRMWARE_UPGRADE
  if ((USBbRequest == DFU_DETACH) && (USBLibStatus2 & DFU_DETACH_RECEIVED)) {
    ReplugDevice();    
  }
#endif
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : Appli_Status_Out
INPUT/OUTPUT : None
DESCRIPTION  : Called by User_Status_Out when a Status OUT is received
-----------------------------------------------------------------------------*/
void Appli_Status_Out(void) {
  // Not used
}

#ifdef HIWARE
#pragma CODE_SEG DEFAULT
#endif

/*** END OF FILE ***/
