#***(c) STMicroelectronics ****************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : HIWARE
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : Make file for the ST7262 16K
#
# HISTORY :
#								                                                              
#******************************************************************************

#*** PRODUCT AND SIZE DEFINITION ***

# Here declare your product name and size 
PRODUCT = 7262
SIZE    = 16K

#*** PATHS DEFINITION ***

# Here you declare the different tools location
TOOLS_PATH = C:\Metrowerks\Prog

#*** I/O FILES DEFINITION ***

ENV_FILE = Default.env
PRM_FILE = ST$(PRODUCT)_$(SIZE).prm
BURN_FILE = Burner.cmd
ABS_FILE = Sectors12.abs

#*** COMMANDS DEFINITION ***

COMP = $(TOOLS_PATH)\Cst7.exe
LINK = $(TOOLS_PATH)\Linker.exe
BURN = $(TOOLS_PATH)\Burner.exe
ASM  = $(TOOLS_PATH)\Ast7.exe

#*** COMPILER OPTIONS ***

# Basic
#COMPOPTIONS = -N -Cc -Ml -F7 -Lasm=%n.lst
# Highest density code
COMPOPTIONS = -N -Cc -Ml -F7 -Lasm=%n.lst -Os -Ou -Of -Ol0 -OnPMNC -Or
# Lowest debug complexity
#COMPOPTIONS = -N -Cc -Ml -F7 -Lm -Lasm=%n.lst -Os -Onu -Onf -Ol0 -Onbt -Onca -Oncn -One -Ont=

#*** ASSEMBLER OPTIONS ***

ASMOPTIONS = -Ml -l

#*** COMMANDS ***

CC = $(COMP) $(COMPOPTIONS) -DMAP_FILE="Map_$(PRODUCT).h" -DST$(PRODUCT) -DHIWARE
AS = $(ASM) $(ASMOPTIONS)

#*** OBJECTS FILES DEFINITION ***

OBJ_LIST = Map_$(PRODUCT).o \
           Applet.o Descript.o HIDLayer.o Int_$(PRODUCT).o Main.o My_Init.o USB_App.o User_Var.o \
           USB_Var.o USB_Rwu.o DFUJumpTableS1S2_$(PRODUCT)_Hiware.o
	    
#*** LINKING ***

$(ABS_FILE) :	$(ENV_FILE) $(OBJ_LIST) $(PRM_FILE)
		$(LINK) $(PRM_FILE)

#*** BURNING ***

		$(BURN) -f $(BURN_FILE)

#*** COMPILATION ***

# ----------------
# MICRO DIRECTORY
# ----------------
                               
Map_$(PRODUCT).o :	$(ENV_FILE) Map_$(PRODUCT).c 
			$(CC) Map_$(PRODUCT).c

# ----------------
# APPLI DIRECTORY
# ----------------

Applet.o :	$(ENV_FILE) Applet.c
		$(CC) Applet.c

Descript.o :	$(ENV_FILE) Descript.c
		$(CC) Descript.c
                                
HIDLayer.o :	$(ENV_FILE) HIDLayer.c
		$(CC) HIDLayer.c

Int_$(PRODUCT).o :	$(ENV_FILE) Int_$(PRODUCT).c
			$(CC) Int_$(PRODUCT).c
											
Main.o :	$(ENV_FILE) Main.c 
		$(CC) Main.c

My_Init.o :	$(ENV_FILE) My_Init.c
		$(CC) My_Init.c 

USB_App.o :	$(ENV_FILE) USB_App.c
		$(CC) USB_App.c
		
User_Var.o :	$(ENV_FILE) User_Var.c
		$(CC) User_Var.c 

# --------------
# USB DIRECTORY
# --------------

USB_Var.o :	$(ENV_FILE) USB_Var.c 
		$(CC) USB_Var.c

USB_Rwu.o :	$(ENV_FILE) USB_Rwu.c 
		$(CC) USB_Rwu.c  

# -------------
# DFU DIRECTORY
# -------------

DFUJumpTableS1S2_$(PRODUCT)_Hiware.o :	$(ENV_FILE) DFUJumpTableS1S2_$(PRODUCT)_Hiware.asm
		$(AS) DFUJumpTableS1S2_$(PRODUCT)_Hiware.asm

#*** END OF FILE ***