/*** (c) STMicroelectronics ***************************************************
#
# PROJECT :
#
# COMPILER : COSMIC / HIWARE
#
# VERSION :
#
# DESCRIPTION : Interrupt functions for ST7263B.
#								                                                              
******************************************************************************/

#include "Macro.h" 
#include "Lib_Bits.h"

#ifdef COSMIC
#pragma section (APPLI_CODE)
#endif

#ifdef HIWARE
#include MAP_FILE
#pragma CODE_SEG APPLI_CODE
#endif

/* ************************ INTERRUPT FUNCTIONS *******************************/

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Flash
DESCRIPTION  : Flash start programming
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Flash(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Flash(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Trap
DESCRIPTION  : TRAP interrupt routine.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Trap(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Trap(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_IT1IT8
DESCRIPTION  : External Interrupts. Used for Remote WakeUp (SW2 on PA4 = IT1) 
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_IT1IT8(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC SAVE_REGS
void INT_IT1IT8(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Timer
DESCRIPTION  : Comes from the Timer cell
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Timer(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Timer(void)
#endif
{                               
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_I2c
DESCRIPTION  : Comes from the I2C cell.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_I2c(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_I2c(void)
#endif
{ 
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Sci
DESCRIPTION  : SCI Interrupt routine.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Sci(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Sci(void)
#endif
{
}

#ifdef COSMIC
#pragma section ()
#endif

#ifdef HIWARE
#pragma CODE_SEG DEFAULT
#endif

/*** END OF FILE ***/