/*** (c) STMicroelectronics ***************************************************
#
# PROJECT :
#
# COMPILER : COSMIC / HIWARE
#
# VERSION :
#
# DESCRIPTION : Entry file.
#
******************************************************************************/

#include "Macro.h"
#include "Lib_Bits.h"

#ifdef COSMIC
#pragma section const {APPLI_CONST}
#pragma section (APPLI_CODE)
#endif

#ifdef HIWARE
#include MAP_FILE
#pragma CONST_SEG APPLI_CONST
#pragma CODE_SEG APPLI_CODE
#endif

const Byte LEDSEQ[8] = {0x80, 0x40, 0x80, 0x40, 0xC0, 0x00, 0xC0, 0x00};

unsigned char SeqIdx;

/*-----------------------------------------------------------------------------
ROUTINE NAME : Tempo
INPUT/OUTPUT : None
DESCRIPTION  : Wait loop for LEDs display.
-----------------------------------------------------------------------------*/     
void Tempo(void) {
#asm
  LD   Y, #5
  CLR  X
  CLR  A
loop:
  INC  X
  JRNE loop
  INC  A
  JRNE loop
  DEC  Y
  JRNE loop
#endasm
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : Init_Appli
INPUT/OUTPUT : None
DESCRIPTION  : Initialization of Application.
-----------------------------------------------------------------------------*/     
void Init_Appli(void) {
  // LED1 & LED2
  PADR  = 0xC0;
  PADDR = 0xC0;
  // LED3 & LED4  
  PBDR  = 0xC0;
  PBDDR = 0xC0;
  SeqIdx = 0;
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : Stop_Appli
INPUT/OUTPUT : None
DESCRIPTION  : Stop the Application.
-----------------------------------------------------------------------------*/     
void Stop_Appli(void) {
  // LED1 & LED2 OFF
  PADR  = 0xC0;
  // LED3 & LED4 OFF 
  PBDR  = 0xC0;
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : Application
INPUT/OUTPUT : None
DESCRIPTION  : Application...
-----------------------------------------------------------------------------*/     
void Application(void) {
  PADR = LEDSEQ[SeqIdx++];
  Tempo();
  if (SeqIdx > 7) SeqIdx = 0;
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : main
INPUT/OUTPUT : None
DESCRIPTION  : The reset vector points on main().
-----------------------------------------------------------------------------*/     
void main(void) {          

  Init_Appli();
      
  while (1) {
      
     //------------------------------------------------------------------
     // MANDATORY: USED TO GO INTO DFU MODE WHEN THE USB CABLE IS PLUGGED		 
     //------------------------------------------------------------------
     if (ValBit(PBDR, 5)) { // Check if Vbus is present ?
       Stop_Appli();       
       WDGCR = 0x80; // MCU Reset
     }
     else {
       Application();
     }  
     
  } // End of while
  
} // End of main

#ifdef COSMIC
#pragma section const {}
#pragma section ()
#endif

#ifdef HIWARE
#pragma CODE_SEG DEFAULT
#pragma CONST_SEG DEFAULT
#endif

/*** END OF FILE ***/