/*** (c) STMicroelectronics ***************************************************
#
# PROJECT :
#
# COMPILER : COSMIC
#
# VERSION :
#
# DESCRIPTION : ST7263B Interrupt vectors call table.
#
******************************************************************************/

// Define interrupt service routines as external functions

//extern void _stext(); // -> use with startup file crts*.s
extern void INT_Trap(); 
extern void INT_EndSusp();
extern void INT_IT1IT8();
extern void INT_Timer();
extern void INT_I2c();
extern void INT_Sci();
extern void INT_Usb();
extern void INT_Flash();
extern void DFU_Main();

// Assign ISR to interrupt vectors

#pragma section const {vector}

void (* const _vectab[])() = 
{
	INT_Usb,
	INT_Sci,
	INT_I2c,
	INT_Timer,
	INT_IT1IT8,
	INT_EndSusp,
	INT_Flash,
	INT_Trap,
	DFU_Main // FFFEh-FFFFh : reset vector
};                     

/*** END OF FILE ***/