#***(c) STMicroelectronics ****************************************************
#
# PROJECT :
#
# COMPILER : HIWARE
#
# VERSION :
#
# DESCRIPTION : Make file for the ST7263B 16K
#
#******************************************************************************

#*** PRODUCT AND SIZE DEFINITION ***

# Here declare your product name and size 
PRODUCT = 7263B
SIZE    = 16K

#*** PATHS DEFINITION ***

# Here you declare the different tools location
TOOLS_PATH = C:\Metrowerks\Prog

#*** I/O FILES DEFINITION ***

ENV_FILE = Default.env
PRM_FILE = ST$(PRODUCT)_$(SIZE).prm
BURN_FILE = Burner.cmd
ABS_FILE = DFUnoUSBapp.abs

#*** COMMANDS DEFINITION ***

COMP = $(TOOLS_PATH)\Cst7.exe
LINK = $(TOOLS_PATH)\Linker.exe
BURN = $(TOOLS_PATH)\Burner.exe
ASM  = $(TOOLS_PATH)\Ast7.exe

#*** COMPILER OPTIONS ***

# Basic
#COMPOPTIONS = -N -Cc -Ml -F7 -Lasm=%n.lst
# Highest density code
COMPOPTIONS = -N -Cc -Ml -F7 -Lasm=%n.lst -Os -Ou -Of -Ol0 -OnPMNC -Or
# Lowest debug complexity
#COMPOPTIONS = -N -Cc -Ml -F7 -Lm -Lasm=%n.lst -Os -Onu -Onf -Ol0 -Onbt -Onca -Oncn -One -Ont=

#*** ASSEMBLER OPTIONS ***

ASMOPTIONS = -Ml -l

#*** COMMANDS ***

CC = $(COMP) $(COMPOPTIONS) -DMAP_FILE="Map_$(PRODUCT).h" -DST$(PRODUCT) -DHIWARE
AS = $(ASM) $(ASMOPTIONS)

#*** OBJECTS FILES DEFINITION ***

OBJ_LIST = Map_$(PRODUCT).o Int_$(PRODUCT).o Main.o Info.o \
           USB.o USB_Lib.o USB_Rc.o USB_Var.o \
           DFUCore.o DFUDescript.o DFUProtocol.o

#*** LINKING ***

$(ABS_FILE) :	$(ENV_FILE) $(OBJ_LIST) $(PRM_FILE)
		$(LINK) $(PRM_FILE)

#*** BURNING ***

		$(BURN) -f $(BURN_FILE)

#*** COMPILATION ***

# ----------------
# MICRO DIRECTORY
# ----------------
                               
Map_$(PRODUCT).o :	$(ENV_FILE) Map_$(PRODUCT).c 
			$(CC) Map_$(PRODUCT).c

# ----------------
# APPLI DIRECTORY
# ----------------
			
Int_$(PRODUCT).o :	$(ENV_FILE) Int_$(PRODUCT).c
			$(CC) Int_$(PRODUCT).c

Main.o :		$(ENV_FILE) Main.c 
			$(CC) Main.c

Info.o :		$(ENV_FILE) Info.c 
			$(CC) Info.c

# --------------
# USB DIRECTORY
# --------------

USB.o :			$(ENV_FILE) USB.c 
			$(CC) USB.c
				
USB_Lib.o :		$(ENV_FILE) USB_Lib.c 
			$(CC) USB_Lib.c  

USB_Rc.o :		$(ENV_FILE) USB_Rc.c 
			$(CC) USB_Rc.c  

USB_Var.o :		$(ENV_FILE) USB_Var.c 
			$(CC) USB_Var.c

# -------------
# DFU DIRECTORY
# -------------

DFUCore.o :		$(ENV_FILE) DFUCore.c 
			$(CC) DFUCore.c

DFUDescript.o :		$(ENV_FILE) DFUDescript.c
			$(CC) DFUDescript.c

DFUProtocol.o :		$(ENV_FILE) DFUProtocol.c
			$(CC) DFUProtocol.c
		
#*** END OF FILE ***
