//******************************************************************************
// UntST7DFU: unit to access DFU class functions.
//******************************************************************************
unit uST7DFU;

interface

uses
  Windows;

const

  //**************************************************************************
  //	Error Codes
  //**************************************************************************

  STDFU_ERROR_OFFSET			= $12340000;

  STDFU_NOERROR				= STDFU_ERROR_OFFSET;
  STDFU_MEMORY				= (STDFU_ERROR_OFFSET+$01);
  STDFU_BADPARAMETER			= (STDFU_ERROR_OFFSET+$02);

  STDFU_NOTIMPLEMENTED			= (STDFU_ERROR_OFFSET+$03);
  STDFU_ENUMFINISHED			= (STDFU_ERROR_OFFSET+$04);
  STDFU_OPENDRIVERERROR			= (STDFU_ERROR_OFFSET+$05);

  STDFU_ERRORDESCRIPTORBUILDING		= (STDFU_ERROR_OFFSET+$06);
  STDFU_PIPECREATIONERROR		= (STDFU_ERROR_OFFSET+$07);
  STDFU_PIPERESETERROR			= (STDFU_ERROR_OFFSET+$08);
  STDFU_PIPEABORTERROR			= (STDFU_ERROR_OFFSET+$09);
  STDFU_STRINGDESCRIPTORERROR		= (STDFU_ERROR_OFFSET+$0A);

  STDFU_DRIVERISCLOSED			= (STDFU_ERROR_OFFSET+$0B);
  STDFU_VENDOR_RQ_PB			= (STDFU_ERROR_OFFSET+$0C);
  STDFU_ERRORWHILEREADING		= (STDFU_ERROR_OFFSET+$0D);
  STDFU_ERRORBEFOREREADING		= (STDFU_ERROR_OFFSET+$0E);
  STDFU_ERRORWHILEWRITING		= (STDFU_ERROR_OFFSET+$0F);
  STDFU_ERRORBEFOREWRITING		= (STDFU_ERROR_OFFSET+$10);
  STDFU_DEVICERESETERROR		= (STDFU_ERROR_OFFSET+$11);
  STDFU_CANTUSEUNPLUGEVENT		= (STDFU_ERROR_OFFSET+$12);
  STDFU_INCORRECTBUFFERSIZE		= (STDFU_ERROR_OFFSET+$13);
  STDFU_DESCRIPTORNOTFOUND		= (STDFU_ERROR_OFFSET+$14);
  STDFU_PIPESARECLOSED			= (STDFU_ERROR_OFFSET+$15);
  STDFU_PIPESAREOPEN			= (STDFU_ERROR_OFFSET+$16);

  STDFU_TIMEOUTWAITINGFORRESET		= (STDFU_ERROR_OFFSET+$17);

  //**************************************************************************
  //	DFU States
  //**************************************************************************

  STATE_IDLE				= $00;
  STATE_DETACH				= $01;
  STATE_DFU_IDLE			= $02;
  STATE_DFU_DOWNLOAD_SYNC		= $03;
  STATE_DFU_DOWNLOAD_BUSY		= $04;
  STATE_DFU_DOWNLOAD_IDLE		= $05;
  STATE_DFU_MANIFEST_SYNC		= $06;
  STATE_DFU_MANIFEST			= $07;
  STATE_DFU_MANIFEST_WAIT_RESET		= $08;
  STATE_DFU_UPLOAD_IDLE			= $09;
  STATE_DFU_ERROR			= $0A;

  //**************************************************************************
  //	DFU Status
  //**************************************************************************

  STATUS_OK				= $00;

type

  //**************************************************************************
  //	DFU Status structure
  //**************************************************************************

  TDFUSTATUS = record
    bStatus: Byte;
    bwPollTimeout: array[0..2] of Byte;
    bState: Byte;
    iString: Byte;
  end;
  PDFUSTATUS = ^TDFUSTATUS;

  //**************************************************************************
  //	DFU Functional Descriptor structure
  //**************************************************************************

  TDFU_FUNCTIONAL_DESCRIPTOR = record
    bLength: Byte;
    bDescriptorType: Byte;
    bmAttributes: Byte;
    wDetachTimeOut: Word;
    wTransfertSize: Word;
  end;
  PDFU_FUNCTIONAL_DESCRIPTOR = ^TDFU_FUNCTIONAL_DESCRIPTOR;

  //**************************************************************************
  //	USB Device Descriptor structure
  //**************************************************************************

  USB_DEVICE_DESCRIPTOR = packed record
    bLength : Byte;
    bDescriptorType: Byte;
    bcdUSB : Word;
    bDeviceClass: Byte;
    bDeviceSubClass: Byte;
    bDeviceProtocol: Byte;
    bMaxPacketSize0: Byte;
    idVendor: Word;
    idProduct: Word;
    bcdDevice: Word;
    iManufacturer: Byte;
    iProduct: Byte;
    iSerialNumber: Byte;
    bNumConfigurations: Byte;
  end;
  PUSB_DEVICE_DESCRIPTOR = ^USB_DEVICE_DESCRIPTOR;

  //**************************************************************************
  //	USB Endpoint Descriptor structure
  //**************************************************************************

  USB_ENDPOINT_DESCRIPTOR = packed record
    bLength: Byte;
    bDescriptorType: Byte;
    bEndpointAddress: Byte;
    bmAttributes: Byte;
    wMaxPacketSize: Word;
    bInterval: Byte;
  end;
  PUSB_ENDPOINT_DESCRIPTOR = ^USB_ENDPOINT_DESCRIPTOR;

  //**************************************************************************
  //	USB Configuration Descriptor structure
  //**************************************************************************

  USB_CONFIGURATION_DESCRIPTOR = packed record
    bLength: Byte;
    bDescriptorType: Byte;
    wTotalLength: Word;
    bNumInterfaces: Byte;
    bConfigurationValue: byte;
    iConfiguration: Byte;
    bmAttributes: Byte;
    MaxPower: Byte;
  end;
  PUSB_CONFIGURATION_DESCRIPTOR = ^USB_CONFIGURATION_DESCRIPTOR;

  //**************************************************************************
  //	USB Interface Descriptor structure
  //**************************************************************************

  USB_INTERFACE_DESCRIPTOR = packed record
    bLength: Byte;
    bDescriptorType: Byte;
    bInterfaceNumber: Byte;
    bAlternateSetting: Byte;
    bNumEndpoints: Byte;
    bInterfaceClass: Byte;
    bInterfaceSubClass: Byte;
    bInterfaceProtocol: Byte;
    iInterface: Byte;
  end;
  PUSB_INTERFACE_DESCRIPTOR = ^USB_INTERFACE_DESCRIPTOR;
  
  //**************************************************************************
  //	Available Functions
  //**************************************************************************

  function STDFU_EnumGetNbDevices (pNb: PDWORD; hWnd: HWND; Message: DWORD):DWORD;cdecl;
  function STDFU_GetDeviceDescriptor (Num: DWORD; pDesc: PUSB_DEVICE_DESCRIPTOR):DWORD;cdecl;
  function STDFU_GetDFUDescriptor (Num: DWORD; pDesc: PDFU_FUNCTIONAL_DESCRIPTOR; pNbOfDFUInterface: PUINT):DWORD;cdecl;
  function STDFU_GetStringDescriptor (Num: DWORD; Index: DWORD; szString: LPSTR; nStringLength: UINT):DWORD;cdecl;
  function STDFU_GetNbOfConfigurations (Num: DWORD; pNbOfConfigs: PUINT):DWORD;cdecl;
  function STDFU_GetConfigurationDescriptor (Num: DWORD; nConfigIdx: UINT; pDesc: PUSB_CONFIGURATION_DESCRIPTOR):DWORD;cdecl;
  function STDFU_GetNbOfInterfaces (Num: DWORD; nConfigIdx: UINT; pNbOfInterfaces: PUINT):DWORD;cdecl;
  function STDFU_GetNbOfAlternates (Num: DWORD; nConfigIdx: UINT; nInterfaceIdx: UINT; pNbOfAltSets: PUINT):DWORD;cdecl;
  function STDFU_GetInterfaceDescriptor (Num: DWORD; nConfigIdx: UINT; nInterfaceIdx: UINT; nAltSetIdx: UINT; pDesc: PUSB_INTERFACE_DESCRIPTOR):DWORD;cdecl;
  function STDFU_Open (Num: DWORD; phDevice: PHANDLE):DWORD;cdecl;
  function STDFU_Close (phDevice: PHANDLE):DWORD;cdecl;
  function STDFU_Detach (phDevice: PHANDLE; wTimeout: Word; DFUInterfaceNumber: UCHAR):DWORD;cdecl;
  function STDFU_Dnload (phDevice: PHANDLE; pBuffer: PUCHAR; nBytes: ULONG; nBlock: Word):DWORD;cdecl;
  function STDFU_Upload (phDevice: PHANDLE; pBuffer: PUCHAR; nBytes: ULONG; nBlock: Word):DWORD;cdecl;
  function STDFU_Getstatus (phDevice: PHANDLE; DfuStatus: PDFUSTATUS):DWORD;cdecl;
  function STDFU_Clrstatus (phDevice: PHANDLE):DWORD;cdecl;
  function STDFU_Getstate (phDevice: PHANDLE; pState: PUCHAR):DWORD;cdecl;
  function STDFU_Abort (phDevice: PHANDLE):DWORD;cdecl;
  function STDFU_HandleDeviceChange (wParam: WPARAM; lParam: LPARAM):Boolean;cdecl;

implementation

  function STDFU_EnumGetNbDevices (pNb: PDWORD; hWnd: HWND; Message: DWORD):DWORD;external 'ST7DFU.dll';
  function STDFU_GetDeviceDescriptor (Num: DWORD; pDesc: PUSB_DEVICE_DESCRIPTOR):DWORD;external 'ST7DFU.dll';
  function STDFU_GetDFUDescriptor (Num: DWORD; pDesc: PDFU_FUNCTIONAL_DESCRIPTOR; pNbOfDFUInterface: PUINT):DWORD;external 'ST7DFU.dll';
  function STDFU_GetStringDescriptor (Num: DWORD; Index: DWORD; szString: LPSTR; nStringLength: UINT):DWORD;external 'ST7DFU.dll';
  function STDFU_GetNbOfConfigurations (Num: DWORD; pNbOfConfigs: PUINT):DWORD;external 'ST7DFU.dll';
  function STDFU_GetConfigurationDescriptor (Num: DWORD; nConfigIdx: UINT; pDesc: PUSB_CONFIGURATION_DESCRIPTOR):DWORD;external 'ST7DFU.dll';
  function STDFU_GetNbOfInterfaces (Num: DWORD; nConfigIdx: UINT; pNbOfInterfaces: PUINT):DWORD;external 'ST7DFU.dll';
  function STDFU_GetNbOfAlternates (Num: DWORD; nConfigIdx: UINT; nInterfaceIdx: UINT; pNbOfAltSets: PUINT):DWORD;external 'ST7DFU.dll';
  function STDFU_GetInterfaceDescriptor (Num: DWORD; nConfigIdx: UINT; nInterfaceIdx: UINT; nAltSetIdx: UINT; pDesc: PUSB_INTERFACE_DESCRIPTOR):DWORD;external 'ST7DFU.dll';
  function STDFU_Open (Num: DWORD; phDevice: PHANDLE):DWORD;external 'ST7DFU.dll';
  function STDFU_Close (phDevice: PHANDLE):DWORD;external 'ST7DFU.dll';
  function STDFU_Detach (phDevice: PHANDLE; wTimeout: Word; DFUInterfaceNumber: UCHAR):DWORD;external 'ST7DFU.dll';
  function STDFU_Dnload (phDevice: PHANDLE; pBuffer: PUCHAR; nBytes: ULONG; nBlock: Word):DWORD;external 'ST7DFU.dll';
  function STDFU_Upload (phDevice: PHANDLE; pBuffer: PUCHAR; nBytes: ULONG; nBlock: Word):DWORD;external 'ST7DFU.dll';
  function STDFU_Getstatus (phDevice: PHANDLE; DfuStatus: PDFUSTATUS):DWORD;external 'ST7DFU.dll';
  function STDFU_Clrstatus (phDevice: PHANDLE):DWORD;external 'ST7DFU.dll';
  function STDFU_Getstate (phDevice: PHANDLE; pState: PUCHAR):DWORD;external 'ST7DFU.dll';
  function STDFU_Abort (phDevice: PHANDLE):DWORD;external 'ST7DFU.dll';
  function STDFU_HandleDeviceChange (wParam: WPARAM; lParam: LPARAM):Boolean;external 'ST7DFU.dll';

end.