/*** (c) STMicroelectronics ***************************************************
#
# COMPILER : COSMIC / HIWARE
#
# DESCRIPTION : Register mapping header file for ST7261
#
******************************************************************************/

#ifndef MAP_7261_H
#define MAP_7261_H

/* PORTA REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTA
#endif

extern volatile unsigned char PADR;
extern volatile unsigned char PADDR;

/* PORTB REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTB
#endif

extern volatile unsigned char PBDR;
extern volatile unsigned char PBDDR;

/* INTERRUPT 1 REGISTER */

#ifdef HIWARE
#pragma DATA_SEG SHORT EXT_INT1
#endif

extern volatile unsigned char ITRFRE1;

/* MISCELLANEOUS REGISTER */

#ifdef HIWARE
#pragma DATA_SEG SHORT MISCR
#endif

extern volatile unsigned char MISCR;

/* WATCHDOG REGISTER */

#ifdef HIWARE
#pragma DATA_SEG SHORT WATCHDOG
#endif

extern volatile unsigned char WDGCR;

/* USB REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT USB
#endif

extern volatile unsigned char USBPIDR;
extern volatile unsigned char USBDMAR;
extern volatile unsigned char USBIDR;
extern volatile unsigned char USBISTR;
extern volatile unsigned char USBIMR;
extern volatile unsigned char USBCTLR;
extern volatile unsigned char USBDADDR;
extern volatile unsigned char USBEP0RA;
extern volatile unsigned char USBEP0RB;
extern volatile unsigned char USBEP1RA;
extern volatile unsigned char USBEP1RB;
extern volatile unsigned char USBEP2RA;
extern volatile unsigned char USBEP2RB;

/* TBU REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT TBU
#endif

extern volatile unsigned char TBUCV;
extern volatile unsigned char TBUCSR;

/* FLASH REGISTER */

#ifdef HIWARE
#pragma DATA_SEG SHORT FLASH
#endif

extern volatile unsigned char FCSR;

/* USB ENDPOINT BUFFERS */

#ifdef HIWARE
#pragma DATA_SEG DMA_CTRL
#endif

extern unsigned char EP0OutBuffer[8];
extern unsigned char EP0InBuffer[8];

#ifdef HIWARE
#pragma DATA_SEG DMA_OUT1
#endif

extern unsigned char EP1OutBuffer[8];

#ifdef HIWARE
#pragma DATA_SEG DMA_IN1
#endif

extern unsigned char EP1InBuffer[8];

#ifdef HIWARE
#pragma DATA_SEG DMA_OUT2
#endif

extern unsigned char EP2OutBuffer[8];

#ifdef HIWARE
#pragma DATA_SEG DMA_IN2
#endif

extern unsigned char EP2InBuffer[8];

#ifdef HIWARE
#pragma DATA_SEG DEFAULT
#endif

#endif // MAP_7262_H

/*** END OF FILE ***/