/*** (c) STMicroelectronics ***************************************************
#
# COMPILER : COSMIC / HIWARE
#
# DESCRIPTION : Register mapping header file for ST7262
#
******************************************************************************/

#ifndef MAP_7262_H
#define MAP_7262_H

/* PORTA REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTA
#endif

extern volatile unsigned char PADR;
extern volatile unsigned char PADDR;

/* PORTB REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTB
#endif

extern volatile unsigned char PBDR;
extern volatile unsigned char PBDDR;

/* PORTC REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTC
#endif

extern volatile unsigned char PCDR;
extern volatile unsigned char PCDDR;

/* PORTD REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTD
#endif

extern volatile unsigned char PDDR;
extern volatile unsigned char PDDDR;

/* INTERRUPT 1 REGISTER */

#ifdef HIWARE
#pragma DATA_SEG SHORT EXT_INT1
#endif

extern volatile unsigned char ITRFRE1;

/* MISCELLANEOUS REGISTER */

#ifdef HIWARE
#pragma DATA_SEG SHORT MISCR
#endif

extern volatile unsigned char MISCR;

/* ADC REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT ADC
#endif

extern volatile unsigned char ADCDRMSB;
extern volatile unsigned char ADCDRLSB;
extern volatile unsigned char ADCCSR;

/* WATCHDOG REGISTER */

#ifdef HIWARE
#pragma DATA_SEG SHORT WATCHDOG
#endif

extern volatile unsigned char WDGCR;

/* SPI REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT SPI
#endif

extern volatile unsigned char SPIDR;
extern volatile unsigned char SPICR;
extern volatile unsigned char SPISR;

/* PWM-ART REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT PWM_ART
#endif

extern volatile unsigned char PWMDCR1;
extern volatile unsigned char PWMDCR0;
extern volatile unsigned char PWMCR;
extern volatile unsigned char ARTCSR;
extern volatile unsigned char ARTCAR;
extern volatile unsigned char ARTARR;
extern volatile unsigned char ARTICCSR;
extern volatile unsigned char ARTICR1;
extern volatile unsigned char ARTICR2;

/* SCI REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT SCI
#endif

extern volatile unsigned char SCIERPR;
extern volatile unsigned char SCIETPR;
extern volatile unsigned char SCI_RESERVED;
extern volatile unsigned char SCISR;
extern volatile unsigned char SCIDR;
extern volatile unsigned char SCIBRR;
extern volatile unsigned char SCICR1;
extern volatile unsigned char SCICR2;

/* USB REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT USB
#endif

extern volatile unsigned char USBPIDR;
extern volatile unsigned char USBDMAR;
extern volatile unsigned char USBIDR;
extern volatile unsigned char USBISTR;
extern volatile unsigned char USBIMR;
extern volatile unsigned char USBCTLR;
extern volatile unsigned char USBDADDR;
extern volatile unsigned char USBEP0RA;
extern volatile unsigned char USBEP0RB;
extern volatile unsigned char USBEP1RA;
extern volatile unsigned char USBEP1RB;
extern volatile unsigned char USBEP2RA;
extern volatile unsigned char USBEP2RB;

/* TBU REGISTERS */

#ifdef HIWARE
#pragma DATA_SEG SHORT TBU
#endif

extern volatile unsigned char TBUCV;
extern volatile unsigned char TBUCSR;

/* FLASH REGISTER */

#ifdef HIWARE
#pragma DATA_SEG SHORT FLASH
#endif

extern volatile unsigned char FCSR;

/* INTERRUPT 2 REGISTER */

#ifdef HIWARE
#pragma DATA_SEG SHORT EXT_INT2
#endif

extern volatile unsigned char ITRFRE2; 

/* USB ENDPOINT BUFFERS */

#ifdef HIWARE
#pragma DATA_SEG DMA_CTRL
#endif

extern unsigned char EP0OutBuffer[8];
extern unsigned char EP0InBuffer[8];

#ifdef HIWARE
#pragma DATA_SEG DMA_OUT1
#endif

extern unsigned char EP1OutBuffer[8];

#ifdef HIWARE
#pragma DATA_SEG DMA_IN1
#endif

extern unsigned char EP1InBuffer[8];

#ifdef HIWARE
#pragma DATA_SEG DMA_OUT2
#endif

extern unsigned char EP2OutBuffer[8];

#ifdef HIWARE
#pragma DATA_SEG DMA_IN2
#endif

extern unsigned char EP2InBuffer[8];

#ifdef HIWARE
#pragma DATA_SEG DEFAULT
#endif

#endif // MAP_7262_H

/*** END OF FILE ***/