/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED LIBRARY
#
# COMPILER : COSMIC / HIWARE
#
# VERSION :
#
# DESCRIPTION : USB lib variables file
#
******************************************************************************/   
                  
#include "USB_Var.h"                  
#include "Macro.h"
#include "USB_Def.h"
#include "Lib_Bits.h"

#ifdef HIWARE
#pragma DATA_SEG SHORT MY_RAM0
#endif

/***************************************************************************/
/*****	VARIABLES SHARED BETWEEN LIB AND APPLI -> proto in USB_Def.h     ***/
/***************************************************************************/

Byte USBLibStatus;
Byte USBTransferStatus;
Byte USBDataXferStatus;
Byte USBbmRequestType; 
Byte USBbRequest;
Byte USBwValue[2];
Word USBwIndex;
Word USBwLength;

/*************************************************************************/
/*****	 	LIBRARY ONLY VARIABLES  -> proto in USB_Var.h       ******/
/*************************************************************************/

Byte OUT_DataNumberEP0;		// Used to save Number of received data on EP0 when Control OUT.

Byte DeviceStatusInfo;
/* This array specifies the status value of the specified 
        recipient (see USB spec.).
        
        For a device:
        DeviceStatusInfo
	  --------------------------------------------------------
	  | Bit7 | Bit6 | Bit5 | Bit4 | Bit3 | Bit2 | Bit1 | Bit0 |
	  --------------------------------------------------------
	  |  -   |  -   | EP2  | EP1  |EP0OUT|EP0IN |Remote| Self |
	  |      |      |      |      |      |      |Wakeup|Power.|  
	  -------------------------------------------------------- 
*/

Byte UsbReport[2];			// Used to report status to host.

Byte UsbInfo;				// Used to keep tracking of device state.

Byte UsbCtrFlag;

Byte *DataToSend;
Byte LengthToSend;
                  
Byte *DescAddBasePointer;

Byte ConfigValue;		// Current Configuration

#ifdef HIWARE
#pragma DATA_SEG DEFAULT
#endif

/*** END OF FILE ***/