/******************** (C) COPYRIGHT 2003 STMicroelectronics ********************
* Author             : MCD Application Team
* Date First Issued  : 16/05/2003
* Description        : This file is used for the AN1782 V2.
********************************************************************************
* History:
*  06/06/2005 :  V2
*  24/11/2004 :  V1.2
*  22/09/2003 :  Created
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Includes-------------------------------------------------------------------*/
#include "71x_lib.h"

/* Include of other module interface headers ---------------------------------*/
#include <stdio.h>

/* Local includes ------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define I2C_SCL 0x2000
#define I2C_SDA 0x4000

#define M24C08_Block0ADDRESS 0xA8
#define M24C08_Block1ADDRESS 0xAA
#define M24C08_Block2ADDRESS 0xAC
#define M24C08_Block3ADDRESS 0xAE

#define STRING "STR7 I2C EEPROM"
#define Buffer_Size (sizeof(STRING)-1)
/* Private macro -------------------------------------------------------------*/

/* Private variables ---------------------------------------------------------*/
char *Tx_Data = STRING;
char  Rx_Data[Buffer_Size] = "";

/* Private function prototypes -----------------------------------------------*/
void EEPROM_Receive(char *pBuffer,u8 BufferSize);
void EEPROM_WaitForlastTask(void);
void EEPROM_Send(void);
void I2C0_Config(void);

/* Interface functions -------------------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

int main(void)
{
  #ifdef DEBUG
    debug();
  #endif

  /* Print Tx buffer */
  printf("Tx_Buffer : %s\n",Tx_Data);

  /* Configure I2C0 interface */
  I2C0_Config();

  /* Send Buffer to the M24C08 */
  EEPROM_Send();

  /* Wait until the EEPROM completes the last operation */
  EEPROM_WaitForlastTask();

  while(1)
  {
    /* Read Buffer from the M24C08 */ 
    EEPROM_Receive(Rx_Data,Buffer_Size);

    /* Print Rx buffer */
    printf("Rx_Buffer : %s\n",Rx_Data);
  }  
}

/*******************************************************************************
* Function Name  : EEPROM_WaitForlastTask
* Description    : Wait for M24C08 EEPROM to terminate the last task
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EEPROM_WaitForlastTask(void)
{
  u32 I2CStatus;

  do
  {
    I2C_STARTGenerate( I2C0, ENABLE );
    while( I2C_FlagStatus( I2C0, DIRECT, I2C_SB) == RESET );

    I2C_AddressSend( I2C0, M24C08_Block3ADDRESS, I2C_Mode7, I2C_TX );
    while(!((I2CStatus = I2C_GetStatus( I2C0 ))& I2C_EVF));

    while( I2C_FlagStatus( I2C0, DIRECT, I2C_ENDAD ) ==RESET );
    I2C_FlagClear( I2C0, I2C_ENDAD );

  }while( I2C_FlagStatus( I2C0, INDIRECT, I2C_AF, I2CStatus ) == SET );
}

/*******************************************************************************
* Function Name  : EEPROM_Receive
* Description    : Read a buffer from the M24C08 EEPROM
* Input          : pBuffer: Pointer to the receive buffer
*                  BufferSize: Buffer size
* Output         : None
* Return         : None
*******************************************************************************/
void EEPROM_Receive(char *pBuffer,u8 BufferSize)
{
  /* Generate the START condition */
  I2C_STARTGenerate (I2C0, ENABLE);
  while (I2C_FlagStatus (I2C0, DIRECT, I2C_SB )== RESET);

  /* Send the EEPROM address with LSB bit reset */
  I2C_AddressSend (I2C0,M24C08_Block3ADDRESS,I2C_Mode7, I2C_TX);
  while (I2C_FlagStatus (I2C0, DIRECT, I2C_ENDAD )== RESET);
  I2C_FlagClear (I2C0, I2C_ENDAD);

  /* Send the EEPROM's internal address to read from */
  I2C_ByteSend (I2C0, 0x00);
  while (I2C_FlagStatus (I2C0, DIRECT, I2C_BTF )==RESET);
  
  /* Generate the RE-START condition */
  I2C_STARTGenerate (I2C0, ENABLE);
  while (I2C_FlagStatus (I2C0, DIRECT, I2C_SB )==RESET);
  
  /* Send the EEPROM address with LSB bit set */
  I2C_AddressSend (I2C0, M24C08_Block3ADDRESS, I2C_Mode7, I2C_RX);
  while (I2C_FlagStatus (I2C0, DIRECT, I2C_ENDAD)==RESET);
  I2C_FlagClear (I2C0, I2C_ENDAD);
  
  /*Read 'Buffer_Size' bytes from the EEPROM starting from address 0x00 of Block3
    and place them in Rx_Data[] array */

  while(BufferSize)
  {
    /* Wait until the byte is received */
    while (I2C_FlagStatus (I2C0, DIRECT, I2C_BTF )==RESET);

    if(BufferSize==2)
    { /* Disable the ACK generation */
      I2C_AcknowledgeConfig (I2C0, DISABLE);
    }

    if (BufferSize==1)
    {
     /* Generate STOP condition to close the communication after the
        next byte reception */ 
      I2C_STOPGenerate (I2C0, ENABLE);
    }

    *pBuffer = I2C_ByteReceive (I2C0);
    pBuffer++;
    BufferSize--;
  }

  /* Enable the ACK generation */
  I2C_AcknowledgeConfig (I2C0, ENABLE);
}

/*******************************************************************************
* Function Name  : EEPROM_Send
* Description    : Send dada to the M24C08 EEPROM
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EEPROM_Send(void)
{
  /* Generate the START condition */
  I2C_STARTGenerate (I2C0, ENABLE);  
  while (I2C_FlagStatus (I2C0, DIRECT, I2C_SB)==RESET);
  
  /* Send the EEPROM address */
  I2C_AddressSend (I2C0, M24C08_Block3ADDRESS, I2C_Mode7, I2C_TX);
  while (I2C_FlagStatus (I2C0, DIRECT, I2C_ENDAD)==RESET);
  I2C_FlagClear (I2C0, I2C_ENDAD);
  
  /* Send the EEPROM's internal address to write to */
  I2C_ByteSend (I2C0, 0x00);
  while (I2C_FlagStatus (I2C0, DIRECT, I2C_BTF )==RESET);
  
  /* Write Tx_Data buffer contents in the EEPROM starting from address 0x00 of
     Block3 */
  I2C_StringSend (I2C0, Tx_Data);
  
  /* Generate the stop condition */
  I2C_STOPGenerate (I2C0, ENABLE);
}

/*******************************************************************************
* Function Name  : I2C0_Config
* Description    : Configure the I2C0 interface
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void I2C0_Config(void)
{
  /* Configure the SDA And the SCL line to alternate function Open Drain */
  GPIO_Config (GPIO1, I2C_SCL|I2C_SDA, GPIO_AF_OD);

  /* Configure the I2C0 peripheral */
  I2C_Init (I2C0);
  I2C_FCLKConfig (I2C0);
  I2C_OnOffConfig (I2C0, ENABLE);
  I2C_SpeedConfig (I2C0, 100000);
  I2C_AcknowledgeConfig (I2C0, ENABLE);
}

/******************* (C) COPYRIGHT 2003 STMicroelectronics *****END OF FILE****/
