/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V2.0.0
* Date               : 08/08/2008
* Description        : Main Program.
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Includes ------------------------------------------------------------------*/
#include "common.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
static u8 Push_Button_Read (void);
static void Push_Button_Config(void);
void SCU_Configuration(void);

/* Private functions ---------------------------------------------------------*/
void SCU_Configuration(void)
{
    SCU_MCLKSourceConfig(SCU_MCLK_OSC);	/* Default configuration */

    /*wait state insertion :This function should be executed from SRAM when*/
    /*booting from bank1 to avoid  Read-While-Write from the Same Bank.*/
    FMI_Config(FMI_READ_WAIT_STATE_2, FMI_WRITE_WAIT_STATE_0, FMI_PWD_ENABLE,\
               FMI_LVD_ENABLE, FMI_FREQ_HIGH);/*Insert 2 Wait States for read*/

    SCU_PLLFactorsConfig(192, 25, 2); /* PLL factors Configuration based on*/
    /* a OSC/Crystal value = 25Mhz*/
    SCU_PLLCmd(ENABLE);  /* PLL Enable and wait for Locking*/
    SCU_RCLKDivisorConfig(SCU_RCLK_Div1); /* RCLK @96Mhz */
    SCU_HCLKDivisorConfig(SCU_HCLK_Div1); /* AHB @96Mhz */
    SCU_FMICLKDivisorConfig(SCU_FMICLK_Div1);/* FMI @96Mhz */
    SCU_PCLKDivisorConfig(SCU_PCLK_Div2); /* APB @48Mhz */
    SCU_MCLKSourceConfig(SCU_MCLK_PLL);  /* MCLK @96Mhz */
    /* Configure the system clocks */
    /* Enable the UART0 Clock */
    SCU_APBPeriphClockConfig(__UART0, ENABLE);
    /* Enable the GPIO3 Clock */
    SCU_APBPeriphClockConfig(__GPIO3, ENABLE);
    /* Enable the GPIO5 Clock */
    SCU_APBPeriphClockConfig(__GPIO5, ENABLE);

}

/*******************************************************************************
* Function Name  : IAP_Init
* Description    : Initilize the IAP(Configure PLL, UART and GPIOs).
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void IAP_Init(void)
{


    GPIO_InitTypeDef GPIO_InitStructure;
    UART_InitTypeDef UART_InitStructure;

    SCU_Configuration();

    /*Gonfigure UART0_Rx pin GPIO5.1*/
    GPIO_InitStructure.GPIO_Direction = GPIO_PinInput;
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1;
    GPIO_InitStructure.GPIO_Type = GPIO_Type_PushPull ;
    GPIO_InitStructure.GPIO_IPInputConnected = GPIO_IPInputConnected_Enable;
    GPIO_InitStructure.GPIO_Alternate = GPIO_InputAlt1  ;
    GPIO_Init(GPIO5, &GPIO_InitStructure);

    /*Gonfigure UART0_Tx pin GPIO3.4*/
    GPIO_InitStructure.GPIO_Direction = GPIO_PinOutput;
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_4;
    GPIO_InitStructure.GPIO_Type = GPIO_Type_PushPull ;
    GPIO_InitStructure.GPIO_Alternate = GPIO_OutputAlt3  ;
    GPIO_Init(GPIO3, &GPIO_InitStructure);

    /* UART0 configured as follow:
          - Word Length = 8 Bits
          - One Stop Bit
          - No parity
          - BaudRate = 115200 baud
          - Hardware flow control Disabled
          - Receive and transmit enabled
          - Receive and transmit FIFOs are Disabled
    */


    UART_InitStructure.UART_WordLength = UART_WordLength_8D;
    UART_InitStructure.UART_StopBits = UART_StopBits_1;
    UART_InitStructure.UART_Parity = UART_Parity_No ;
    UART_InitStructure.UART_BaudRate = 115200;
    UART_InitStructure. UART_HardwareFlowControl = UART_HardwareFlowControl_None;
    UART_InitStructure.UART_Mode = UART_Mode_Tx_Rx;
    UART_InitStructure.UART_FIFO = UART_FIFO_Disable;
    UART_DeInit(UART0);

    UART_Init(UART0, &UART_InitStructure);

    UART_Cmd(UART0, ENABLE);

}

/*******************************************************************************
* Function Name  : Push_Button_Read
* Description    : Read the port pin (connected to the push button) level.
* Input          : None
* Output         : None
* Return         : The port pin level (SET or RESET).
*******************************************************************************/
static u8 Push_Button_Read (void)
{
    /* Return the status of the push button (PB3) on the STR910-EVAL */
    return GPIO_ReadBit(GPIO7, GPIO_Pin_4);
}

/*******************************************************************************
* Function Name  : Push_Button_Config
* Description    : Configures the port pin connected to the push button.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
static void Push_Button_Config(void)
{

    GPIO_InitTypeDef GPIO_InitStructure;

    /*Enable Clock for GPIO7*/
    SCU_APBPeriphClockConfig(__GPIO7, ENABLE);

    /*Configure GPIO7 pin 4*/
    GPIO_DeInit(GPIO7);
    GPIO_StructInit(&GPIO_InitStructure);
    GPIO_InitStructure.GPIO_Direction = GPIO_PinInput;
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_4;
    GPIO_Init (GPIO7, &GPIO_InitStructure);

}
/*******************************************************************************
* Function Name  : main
* Description    : Main program.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main(void)
{

#ifdef DEBUG
    debug();
#endif



    Push_Button_Config();
    if (!Push_Button_Read())    /* If Push Button is pressed */

    {
        /* Execute the IAP driver in order to re-program the Flash */
        IAP_Init();
        SerialPutString("\r\n======================================================================");
        SerialPutString("\r\n=              (C) Copyright 2008 STMicroelectronics                  ");
        SerialPutString("\r\n=                                                                    =");
        SerialPutString("\r\n=     In-Application Programming Application  (Version 2.0.0)        =");
        SerialPutString("\r\n=                                                                    =");
        SerialPutString("\r\n=                                   By MCD Application Team          =");
        SerialPutString("\r\n======================================================================");
        SerialPutString("\r\n\r\n");
        Main_Menu ();
    }
    else
        /* Keep the user application running */
    {
        Execute_STR9Application();
    }

    while (1);
}
/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
