/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : ymodem.c
* Author             : MCD Application Team
* Version            : V2.0.0
* Date               : 08/08/2008
* Description        : This file provides all the software functions related to
*                      the ymodem protocol..
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Includes ------------------------------------------------------------------*/
#include "common.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
u8 file_name[FILE_NAME_LENGTH];
u32 Ram_Source;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
/*******************************************************************************
* Function Name  : Receive_Byte
* Description    : Receive byte from sender
* Input          : - c: Character
*                  - timeout: Timeout
* Output         : None
* Return         : 0: Byte received
*                  -1: Timeout
*******************************************************************************/
static  s32 Receive_Byte (u8 *c, u32 timeout)
{
    while (timeout-- > 0)
    {
        if (SerialKeyPressed(c) == 1)
        {
            return 0;
        }
    }
    return -1;
}

/*******************************************************************************
* Function Name  : Send_Byte
* Description    : Send a byte
* Input          : - c: Character
* Output         : None
* Return         : 0: Byte sent
*******************************************************************************/
static u32 Send_Byte (u8 c)
{
    SerialPutChar(c);
    return 0;
}

/*******************************************************************************
* Function Name  : Receive_Packet
* Description    : Receive a packet from sender
* Input 1        : - data: Data
* Input 2        : - length: Length
* Input 3        : Timeout
* Output         : *length:
*                  0: end of transmission
*                  -1: abort by sender
*                  >0: packet length
* Return         : 0: normally return
*                  -1: timeout or packet error
*                  1: abort by user
*******************************************************************************/
static s32 Receive_Packet (u8 *data, s32 *length, u32 timeout)
{
    u16 i, packet_size;
    u8 c;
    *length = 0;
    if (Receive_Byte(&c, timeout) != 0)
    {
        return -1;
    }
    switch (c)
    {
    case SOH:
        packet_size = PACKET_SIZE;
        break;
    case STX:
        packet_size = PACKET_1K_SIZE;
        break;
    case EOT:
        return 0;
    case CA:
        if ((Receive_Byte(&c, timeout) == 0) && (c == CA))
        {
            *length = -1;
            return 0;
        }
        else
        {
            return -1;
        }
    case ABORT1:
    case ABORT2:
        return 1;
    default:
        return -1;
    }
    *data = c;
    for (i = 1; i < (packet_size + PACKET_OVERHEAD); i ++)
    {
        if (Receive_Byte(data + i, timeout) != 0)
        {
            return -1;
        }
    }
    if (data[PACKET_SEQNO_INDEX] != ((data[PACKET_SEQNO_COMP_INDEX] ^ 0xff) & 0xff))
    {
        return -1;
    }
    *length = packet_size;
    return 0;
}
/*******************************************************************************
* Function Name  : Ymodem_Receive
* Description    : Receive a file using the ymodem protocol
* Input          : Address of the first byte
* Output         : None
* Return         : The size of the file
*******************************************************************************/
s32 Ymodem_Receive (u8 *buf)
{
    u32 Flash_Destination = ApplicationAddress; /* Flash user program offset */

    u8 packet_data[PACKET_1K_SIZE + PACKET_OVERHEAD], file_size[FILE_SIZE_LENGTH], *file_ptr, *buf_ptr;
    s32 i, j, packet_length, session_done, file_done, packets_received, errors, session_begin, size = 0;


    for (session_done = 0, errors = 0, session_begin = 0; ;)
    {
        for (packets_received = 0, file_done = 0, buf_ptr = buf; ;)

        {
            switch (Receive_Packet(packet_data, &packet_length, NAK_TIMEOUT))
            {
            case 0:
                errors = 0;
                switch (packet_length)
                {
                case - 1:    /* Abort by sender */
                    Send_Byte(ACK);
                    return 0;
                case 0:     /* End of transmission */
                    Send_Byte(ACK);
                    file_done = 1;
                    break;
                default:    /* Normal packet */
                    if ((packet_data[PACKET_SEQNO_INDEX] & 0xff) != (packets_received & 0xff))
                    {
                        Send_Byte(NAK);
                    }
                    else
                    {
                        if (packets_received == 0)   /* Filename packet */
                        {
                            if (packet_data[PACKET_HEADER] != 0)    /* Filename packet has valid data */
                            {
                                for (i = 0, file_ptr = packet_data + PACKET_HEADER; (*file_ptr != 0) && (i < FILE_NAME_LENGTH);)
                                {
                                    file_name[i++] = *file_ptr++;
                                }
                                file_name[i++] = '\0';
                                for (i = 0, file_ptr ++; (*file_ptr != ' ') && (i < FILE_SIZE_LENGTH);)
                                {
                                    file_size[i++] = *file_ptr++;
                                }
                                file_size[i++] = '\0';
                                Str2Int(file_size, &size);

                                /* Test the size of the image to be sent */
#ifdef Flash_256KB
                                if (size > 0x40000)/* Image size is greater than bank0 size */
#endif
#ifdef Flash_512KB
                                    if (size > 0x80000)/* Image size is greater than bank0 size */
#endif

#ifdef Flash_1MB
                                        if (size > 0x100000)/* Image size is greater than bank0 size */
#endif

#ifdef Flash_2MB
                                            if (size > 0x200000)/* Image size is greater than bank0 size */
#endif

                                            {
                                                /* End session */
                                                Send_Byte(CA);
                                                Send_Byte(CA);
                                                return -1;
                                            }

                                /* Erase the needed sectors where the user application will be loaded */
                                SCU_AHBPeriphClockConfig(__FMI, ENABLE);
                                SCU_AHBPeriphReset(__FMI, DISABLE);
                       


                                if (size > 0x00)
                                {
                                    FMI_WriteProtectionCmd(FMI_B0S0, DISABLE);
                                    FMI_EraseSector(FMI_B0S0);
                                    FMI_WaitForLastOperation(FMI_BANK_0);
                                }
                                if (size > 0xFFFF)
                                {

                                    FMI_WriteProtectionCmd(FMI_B0S1, DISABLE);

                                    FMI_EraseSector(FMI_B0S1);
                                    FMI_WaitForLastOperation(FMI_BANK_0);
                                }
                                if (size > 0x1FFFF)
                                {

                                    FMI_WriteProtectionCmd(FMI_B0S2, DISABLE);

                                    FMI_EraseSector(FMI_B0S2);
                                    FMI_WaitForLastOperation(FMI_BANK_0);
                                }
                                if (size > 0x2FFFF)
                                {

                                    FMI_WriteProtectionCmd(FMI_B0S3, DISABLE);

                                    FMI_EraseSector(FMI_B0S3);
                                    FMI_WaitForLastOperation(FMI_BANK_0);
                                }


                                if (size > 0x3FFFF)
                                {

                                    FMI_WriteProtectionCmd(FMI_B0S4, DISABLE);
                                    FMI_EraseSector(FMI_B0S4);
                                    FMI_WaitForLastOperation(FMI_BANK_0);
                                }
                                if (size > 0x4FFFF)
                                {

                                    FMI_WriteProtectionCmd(FMI_B0S5, DISABLE);
                                    FMI_EraseSector(FMI_B0S5);
                                    FMI_WaitForLastOperation(FMI_BANK_0);
                                }
                                if (size > 0x5FFFF)
                                {

                                    FMI_WriteProtectionCmd(FMI_B0S6, DISABLE);
                                    FMI_EraseSector(FMI_B0S6);
                                    FMI_WaitForLastOperation(FMI_BANK_0);
                                }
                                if (size > 0x6FFFF)
                                {


                                    FMI_WriteProtectionCmd(FMI_B0S7, DISABLE);
                                    FMI_EraseSector(FMI_B0S7);
                                    FMI_WaitForLastOperation(FMI_BANK_0);
                                }

                                if (size > 0x7FFFF)

                                {


                                    FMI_WriteProtectionCmd(FMI_B0S8, DISABLE);
                                    FMI_EraseSector(FMI_B0S8);
                                    FMI_WaitForLastOperation(FMI_BANK_0);
                                }
                                if (size > 0x8FFFF)

                                {


                                    FMI_WriteProtectionCmd(FMI_B0S9, DISABLE);
                                    FMI_EraseSector(FMI_B0S9);
                                    FMI_WaitForLastOperation(FMI_BANK_0);

                                }

                                if (size > 0x9FFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S10, DISABLE);
                                    FMI_EraseSector(FMI_B0S10);
                                    FMI_WaitForLastOperation(FMI_BANK_0);


                                }
                                if (size > 0xAFFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S11, DISABLE);
                                    FMI_EraseSector(FMI_B0S11);
                                    FMI_WaitForLastOperation(FMI_BANK_0);


                                }
                                if (size > 0xBFFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S12, DISABLE);
                                    FMI_EraseSector(FMI_B0S12);
                                    FMI_WaitForLastOperation(FMI_BANK_0);

                                }
                                if (size > 0xCFFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S13, DISABLE);
                                    FMI_EraseSector(FMI_B0S13);
                                    FMI_WaitForLastOperation(FMI_BANK_0);


                                }
                                if (size > 0xDFFFF)


                                {


                                    FMI_WriteProtectionCmd(FMI_B0S14, DISABLE);
                                    FMI_EraseSector(FMI_B0S14);
                                    FMI_WaitForLastOperation(FMI_BANK_0);


                                }
                                if (size > 0xEFFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S15, DISABLE);
                                    FMI_EraseSector(FMI_B0S15);
                                    FMI_WaitForLastOperation(FMI_BANK_0);


                                }
                                if (size > 0xFFFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S16, DISABLE);
                                    FMI_EraseSector(FMI_B0S16);
                                    FMI_WaitForLastOperation(FMI_BANK_0);

                                }
                                if (size > 0x10FFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S17, DISABLE);
                                    FMI_EraseSector(FMI_B0S17);
                                    FMI_WaitForLastOperation(FMI_BANK_0);


                                }
                                if (size > 0x11FFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S18, DISABLE);
                                    FMI_EraseSector(FMI_B0S18);
                                    FMI_WaitForLastOperation(FMI_BANK_0);

                                }
                                if (size > 0x12FFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S19, DISABLE);
                                    FMI_EraseSector(FMI_B0S19);
                                    FMI_WaitForLastOperation(FMI_BANK_0);


                                }
                                if (size > 0x13FFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S20, DISABLE);
                                    FMI_EraseSector(FMI_B0S20);
                                    FMI_WaitForLastOperation(FMI_BANK_0);



                                }
                                if (size > 0x14FFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S21, DISABLE);
                                    FMI_EraseSector(FMI_B0S21);
                                    FMI_WaitForLastOperation(FMI_BANK_0);




                                }
                                if (size > 0x15FFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S22, DISABLE);
                                    FMI_EraseSector(FMI_B0S22);
                                    FMI_WaitForLastOperation(FMI_BANK_0);
                                }
                                if (size > 0x16FFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S23, DISABLE);
                                    FMI_EraseSector(FMI_B0S23);
                                    FMI_WaitForLastOperation(FMI_BANK_0);

                                }
                                if (size > 0x17FFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S24, DISABLE);
                                    FMI_EraseSector(FMI_B0S24);
                                    FMI_WaitForLastOperation(FMI_BANK_0);
                                }
                                if (size > 0x18FFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S25, DISABLE);
                                    FMI_EraseSector(FMI_B0S25);
                                    FMI_WaitForLastOperation(FMI_BANK_0);
                                }
                                if (size > 0x19FFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S26, DISABLE);
                                    FMI_EraseSector(FMI_B0S26);
                                    FMI_WaitForLastOperation(FMI_BANK_0);
                                }
                                if (size > 0x1AFFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S27, DISABLE);
                                    FMI_EraseSector(FMI_B0S27);
                                    FMI_WaitForLastOperation(FMI_BANK_0);
                                }
                                if (size > 0x1BFFFF)


                                {


                                    FMI_WriteProtectionCmd(FMI_B0S28, DISABLE);
                                    FMI_EraseSector(FMI_B0S28);
                                    FMI_WaitForLastOperation(FMI_BANK_0);

                                }
                                if (size > 0x1CFFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S29, DISABLE);
                                    FMI_EraseSector(FMI_B0S29);
                                    FMI_WaitForLastOperation(FMI_BANK_0);

                                }
                                if (size > 0x1DFFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S30, DISABLE);
                                    FMI_EraseSector(FMI_B0S30);
                                    FMI_WaitForLastOperation(FMI_BANK_0);

                                }




                                if (size > 0x1EFFFF)


                                {



                                    FMI_WriteProtectionCmd(FMI_B0S31, DISABLE);
                                    FMI_EraseSector(FMI_B0S31);
                                    FMI_WaitForLastOperation(FMI_BANK_0);

                                }



                                Send_Byte(ACK);
                                Send_Byte(CRC16);
                            }
                            else   /* Filename packet is empty; end session */
                            {
                                Send_Byte(ACK);
                                file_done = 1;
                                session_done = 1;
                                break;
                            }
                        }
                        else    /* Data packet */
                        {
                            memcpy(buf_ptr, packet_data + PACKET_HEADER, packet_length);
                            
                       
                            Ram_Source = 0x4002000;
#ifdef Flash_2MB_1MB
                                SCU_FMICLKDivisorConfig(SCU_FMICLK_Div2);/* FMI @48Mhz */
#endif                            
                            for (j = 0;(j < packet_length) && (Flash_Destination <  ApplicationAddress + size);j += 2)

                            {

                               
				/* Program the data received into STR91x Flash */
                                FMI_WriteHalfWord(Flash_Destination, *(u16*)Ram_Source);
                                FMI_WaitForLastOperation(FMI_BANK_0);
  			       
							
                                if (*(u16*)Flash_Destination != *(u16*)Ram_Source)

                                {
                                    /* End session */

                                    Send_Byte(CA);
                                    Send_Byte(CA);
                                    return -2;
                                }

                                Flash_Destination += 2;
                                Ram_Source += 2;

                            }
#ifdef Flash_2MB_1MB
                             SCU_FMICLKDivisorConfig(SCU_FMICLK_Div1);/* FMI @96Mhz */
#endif

                            Send_Byte(ACK);
                        }
                        packets_received ++;
                        session_begin = 1;
                    }
                }
                break;
            case 1:
                Send_Byte(CA);
                Send_Byte(CA);
                return -3;
            default:
                if (session_begin > 0)
                {
                    errors ++;
                }
                if (errors > MAX_ERRORS)
                {
                    Send_Byte(CA);
                    Send_Byte(CA);
                    return 0;
                }
                Send_Byte(CRC16);
                break;
            }
            if (file_done != 0)
            {
                break;
            }
        }
        if (session_done != 0)
        {
            break;


        }
    }
    return (s32)size;
}

/*******************(C)COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
