/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : execute_application.c
* Author             : MCD Application Team
* Version            : V2.0.0
* Date               : 08/08/2008
* Description        : This file provides the software which allows to software 
*                      remap Bank0 and Bank1 and then jump to the user application.
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Includes ------------------------------------------------------------------*/
#include "execute_application.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/

/*******************************************************************************
* Function Name  : Execute_STR9Application
* Description    : Execute the application loaded in bank0 after remapping it at
*                  address 0 and remapping bank1 at address 0x80000.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/


void Execute_STR9Application(void)

{
    pFunction Jump_To_Application;

#ifdef Flash_512KB_256KB
    FMI->BBSR   = 0x0;
    FMI->NBBSR  = 0x6;
    FMI->BBADR  = 0x80000 >> 2;
#endif

#ifdef Flash_2MB_1MB
    FMI->BBSR   = 0x2;
    FMI->NBBSR  = 0x8;
    FMI->BBADR  = 0x200000 >> 2;
#endif
    FMI->NBBADR = 0x0 ;
    /* Jump to the user application and execute it */
    Jump_To_Application = (pFunction) 0x00;

    Jump_To_Application();
}

/******************(C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE***/
