/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V2.0.0
* Date               : 01/19/2009
* Description        : AN2593 example: The example shows three nested interrupts
*                      two EXTIT interrupts through VIC1 and TIM0 Output Compare 2 
*                      interrupt through VIC0.
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
* CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME. AS
* A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
* OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
* OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
* CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Includes ------------------------------------------------------------------*/
#include "91x_lib.h"


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
TIM_InitTypeDef   TIM_InitStructure;
GPIO_InitTypeDef  GPIO_InitStructure;


/* Private function prototypes -----------------------------------------------*/
void SCU_Configuration(void);
void VICs_Configuration(void);
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/

int main()
{
#ifdef DEBUG
  debug();
#endif

  /* Configure the system clocks */
  SCU_Configuration();
  
  /* Configure interrupts */
  VICs_Configuration();
  
  /*TIM0 Deinitialization*/
  TIM_DeInit(TIM0);

  /*GPIO0 Deinitialization*/
  GPIO_DeInit(GPIO0);

  /*GPIO0 configuration (all output)*/
  GPIO_StructInit(&GPIO_InitStructure);
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_All;
  GPIO_InitStructure.GPIO_Direction = GPIO_PinOutput;
  GPIO_InitStructure.GPIO_Type = GPIO_Type_PushPull;
  GPIO_InitStructure.GPIO_Alternate = GPIO_OutputAlt1;
  GPIO_Init(GPIO0, &GPIO_InitStructure);
  /*TIM0 Structure Initialization*/
  TIM_StructInit(&TIM_InitStructure);

  /*TIM0 Configuration in PWM Mode*/
  TIM_InitStructure.TIM_Mode = TIM_PWM;
  TIM_InitStructure.TIM_Clock_Source = TIM_CLK_APB;
  TIM_InitStructure.TIM_Prescaler = 0x2F;
  TIM_InitStructure.TIM_Pulse_Length_1 = 48;
  TIM_InitStructure.TIM_Full_Period = 96;
  TIM_Init (TIM0, &TIM_InitStructure);

  /*Enable the Timer output compare interrupt*/
  TIM_ITConfig(TIM0, TIM_IT_OC2, ENABLE);

  /*Start the counter of TIM0*/
  TIM_CounterCmd(TIM0, TIM_START);

  
  
  while (1);
}

/*******************************************************************************
* Function Name  : SCU_Configuration
* Description    : Configures the Master clock @96MHz and the Main system 
*                  configuration and Clocks (FMI,PLL,RCLK,HCLK,PCLK ,MCLK )
*                  and enable clocks for peripherals.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SCU_Configuration(void)
{
  SCU_MCLKSourceConfig(SCU_MCLK_OSC);	/* Default configuration */
  
  /*wait state insertion :This function should be executed from SRAM when*/
  /*booting from bank1 to avoid  Read-While-Write from the Same Bank.*/
  FMI_Config(FMI_READ_WAIT_STATE_2, FMI_WRITE_WAIT_STATE_0, FMI_PWD_ENABLE,\
                 FMI_LVD_ENABLE, FMI_FREQ_HIGH);/*Insert 2Wait States for read*/
                                                
  SCU_PLLFactorsConfig(192, 25, 2); /* PLL factors Configuration based on*/
                                        /* a OSC/Crystal value = 25Mhz*/     
  SCU_PLLCmd(ENABLE);  /* PLL Enable and wait for Locking*/     
  SCU_RCLKDivisorConfig(SCU_RCLK_Div1); /* RCLK @96Mhz */
  SCU_HCLKDivisorConfig(SCU_HCLK_Div1); /* AHB @96Mhz */
  SCU_FMICLKDivisorConfig(SCU_FMICLK_Div1);/* FMI @96Mhz */
  SCU_PCLKDivisorConfig(SCU_PCLK_Div2); /* APB @48Mhz */
  SCU_MCLKSourceConfig(SCU_MCLK_PLL);  /* MCLK @96Mhz */
  
  SCU_APBPeriphClockConfig(__GPIO0, ENABLE);/* Enable the clock for GPIO0*/
  SCU_APBPeriphClockConfig(__TIM01, ENABLE);/*Enable the clock for TIM0 & TIM1*/
  SCU_AHBPeriphClockConfig(__VIC,ENABLE);   /* Enable the clock to VIC*/
} 


/*******************************************************************************
* Function Name  : VICs_Configuration
* Description    : Initialize VIC , configure TIM0 output compare2 interrupt and 
*                  configure EXTIT0/EXTIT1 software  interrupt.               
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void VICs_Configuration (void)
{
   /*VIC Deinitialization*/
  VIC_DeInit();

  /*Initialize VICs Default vector address registers*/
  VIC_InitDefaultVectors();

  /*Configure the output compare  interrupt*/
  VIC_Config(TIM0_ITLine, VIC_IRQ, 0); 
  VIC_ITCmd(TIM0_ITLine, ENABLE);

  
  /* Configure the External interrupt 1 */
  VIC_Config(EXTIT1_ITLine, VIC_IRQ, 1); 
  VIC_ITCmd(EXTIT1_ITLine, ENABLE);
  
  
/* Configure the External interrupt 0 */
  VIC_Config(EXTIT0_ITLine, VIC_IRQ, 2);  
  VIC_ITCmd(EXTIT0_ITLine, ENABLE);
  
  
} 
/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
