/**
  ******************************************************************************
  * @file    dali_config.c
  * @author  STMicroelectronics - MCD Application Team
  * @version V2.0.0
  * @date    07/04/2011
  * @brief   User configuration of DALI hardware and stack
  ******************************************************************************
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2011 STMicroelectronics</center></h2>
  ******************************************************************************
  */

#include "stm8s.h"
#include "dali_config.h"


/*  ------------------------ Default DALI registers ------------------------ */
const u8 DaliRegDefaults[] =
 {
  //RAM regs
  254,                        // DALIREG_ACTUAL_DIM_LEVEL      0
  0xFF,                       // DALIREG_SEARCH_ADDRESS        1
  0xFF,                       //
  0xFF,                       //
  0,                          // DALIREG_STATUS_INFORMATION    4
  //EEPROM regs
  254,                        // DALIREG_POWER_ON_LEVEL        5
  254,                        // DALIREG_SYSTEM_FAILURE_LEVEL  6
  PHYSICAL_MIN_LEVEL_ROM,     // DALIREG_MIN_LEVEL             7
  254,                        // DALIREG_MAX_LEVEL             8
  7,                          // DALIREG_FADE_RATE             9
  0,                          // DALIREG_FADE_TIME            10
  0,                          // DALIREG_SHORT_ADDRESS        11
  0xFF,                       // DALIREG_RANDOM_ADDRESS       12
  0xFF,                       // DALIREG_RANDOM_ADDRESS       13
  0xFF,                       // DALIREG_RANDOM_ADDRESS       14
  0,                          // DALIREG_GROUP_0_7            15
  0,                          // DALIREG_GROUP_8_15           16
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF, // DALIREG_SCENE                17-24
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF, // DALIREG_SCENE                25-32
  //ROM regs
  DALI_VERSION_NUMBER_ROM,    // DALIREG_VERSION_NUMBER       33
  PHYSICAL_MIN_LEVEL_ROM      // DALIREG_PHYS_MIN_LEVEL       34
};


#ifdef USE_ARC_TABLE
/**********************************************
 * Fill in the Numbers (see Spec)             *
 * then uncomment                             *
 **********************************************/

/*
//linear table for maximum set to 65535
const u16 DALIP_ArcTable[]={
      0,  258,  516,  774, 1032, 1290, 1548, 1806, 2064, 2322, 2580, 2838, 3096, 3354, 3612, 3870,
   4128, 4386, 4644, 4902, 5160, 5418, 5676, 5934, 6192, 6450, 6708, 6966, 7224, 7482, 7740, 7998,
   8256, 8514, 8772, 9030, 9288, 9546, 9804,10062,10320,10578,10836,11095,11353,11611,11869,12127,
  12385,12643,12901,13159,13417,13675,13933,14191,14449,14707,14965,15223,15481,15739,15997,16255,
  16513,16771,17029,17287,17545,17803,18061,18319,18577,18835,19093,19351,19609,19867,20125,20383,
  20641,20899,21157,21415,21673,21931,22189,22447,22705,22963,23221,23479,23737,23995,24253,24511,
  24769,25027,25285,25543,25801,26059,26317,26575,26833,27091,27349,27607,27865,28123,28381,28639,
  28897,29155,29413,29671,29929,30187,30445,30703,30961,31219,31477,31735,31993,32251,32509,32768,
  33026,33284,33542,33800,34058,34316,34574,34832,35090,35348,35606,35864,36122,36380,36638,36896,
  37154,37412,37670,37928,38186,38444,38702,38960,39218,39476,39734,39992,40250,40508,40766,41024,
  41282,41540,41798,42056,42314,42572,42830,43088,43346,43604,43862,44120,44378,44636,44894,45152,
  45410,45668,45926,46184,46442,46700,46958,47216,47474,47732,47990,48248,48506,48764,49022,49280,
  49538,49796,50054,50312,50570,50828,51086,51344,51602,51860,52118,52376,52634,52892,53150,53408,
  53666,53924,54182,54440,54699,54957,55215,55473,55731,55989,56247,56505,56763,57021,57279,57537,
  57795,58053,58311,58569,58827,59085,59343,59601,59859,60117,60375,60633,60891,61149,61407,61665,
  61923,62181,62439,62697,62955,63213,63471,63729,63987,64245,64503,64761,65019,65277,65535,65535
};
*/

//logarithmic table for maximum set to 65535
const u16 DALIP_ArcTable[]={
      0,   66,   67,   69,   71,   73,   75,   77,   79,   82,   84,   86,   88,   91,   93,   96,
     99,  101,  104,  107,  110,  113,  116,  119,  123,  126,  130,  133,  137,  141,  145,  149,
    153,  157,  161,  166,  170,  175,  180,  185,  190,  195,  201,  206,  212,  218,  224,  230,
    236,  243,  250,  257,  264,  271,  279,  286,  294,  302,  311,  319,  328,  337,  347,  356,
    366,  376,  387,  397,  408,  420,  431,  443,  455,  468,  481,  494,  508,  522,  536,  551,
    567,  582,  598,  615,  632,  649,  667,  686,  705,  724,  744,  765,  786,  808,  830,  853,
    877,  901,  926,  952,  978, 1005, 1033, 1062, 1091, 1121, 1152, 1184, 1217, 1251, 1285, 1321,
   1357, 1395, 1433, 1473, 1514, 1556, 1599, 1643, 1689, 1735, 1783, 1833, 1884, 1936, 1989, 2044,
   2101, 2159, 2219, 2280, 2343, 2408, 2475, 2543, 2614, 2686, 2760, 2837, 2915, 2996, 3079, 3164,
   3252, 3342, 3434, 3529, 3627, 3727, 3831, 3937, 4046, 4158, 4273, 4391, 4513, 4637, 4766, 4898,
   5033, 5173, 5316, 5463, 5614, 5769, 5929, 6093, 6262, 6435, 6613, 6796, 6985, 7178, 7377, 7581,
   7791, 8006, 8228, 8456, 8690, 8930, 9177, 9431, 9692, 9961,10236,10520,10811,11110,11418,11734,
  12059,12392,12735,13088,13450,13822,14205,14598,15002,15418,15844,16283,16734,17197,17673,18162,
  18665,19181,19712,20258,20819,21395,21987,22596,23221,23864,24524,25203,25901,26618,27354,28112,
  28890,29689,30511,31356,32224,33115,34032,34974,35942,36937,37959,39010,40090,41200,42340,43512,
  44716,45954,47226,48533,49877,51257,52676,54134,55632,57172,58755,60381,62052,63770,65535,65535
};


#endif

/*  ------------------------ Fade time table ------------------------ */
const u32 DALIP_FadeTimeTable[]={
      0,
    707,
   1000,
   1414,
   2000,
   2828,
   4000,
   5657,
   8000,
  11314,
  16000,
  22627,
  32000,
  45255,
  64000,
  90510
};

/*  ------------------------ Fade rate table ------------------------ */
const u16 DALIP_FadeRateTable[]={       //ALALremark ms/step
    0,
    3,
    4,
    6,
    8,
   11,
   16,
   22,
   32,
   45,
   63,
   89,
  126,
  178,
  252,
  357
};
