/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Main program body
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/*  Words to be transmitted */
u8 Sendtab[9] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09};
u8 Receivetab[9];

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main routine
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main (void)
{

  #ifdef DEBUG
  debug();
  #endif
  
  /* System clocks configuration ---------------------------------------------*/
  /* MCLK = PCLK1 = PCLK2 = 24MHz*/ 
  
  /* Configure PCLK1 = RCLK / 1 */
  RCCU_PCLK1Config (RCCU_DEFAULT);

  /* Configure PCLK2 = RCLK / 1 */
  RCCU_PCLK2Config (RCCU_DEFAULT);

  /* Configure MCLK clock for the CPU, RCCU_DEFAULT = RCLK /1 */
  RCCU_MCLKConfig (RCCU_DEFAULT);
   
  /* Configure the PLL1 ( * 12 , / 4 ) */
  RCCU_PLL1Config (RCCU_PLL1_Mul_12, RCCU_Div_4) ;

  while(RCCU_FlagStatus(RCCU_PLL1_LOCK) == RESET)
  {
    /* Wait PLL to lock */
  }
  /* Select PLL1_Output as RCLK clock */
  RCCU_RCLKSourceConfig (RCCU_PLL1_Output) ;

  /* Enable BSPI0 and BSPI1 clocks on APB1 */
  APB_ClockConfig (APB1, ENABLE, BSPI0_Periph | BSPI1_Periph );
 
  /* Enable GPIO0 clock on APB2 */
  APB_ClockConfig (APB2, ENABLE, GPIO0_Periph );

  /* GPIO configuration ------------------------------------------------------*/
  /* Configure MOSIx, MISOx, and SCLKx pins as Alternate function Push Pull */
  GPIO_Config (GPIO0, 0x0077, GPIO_AF_PP);

  /* Configure nSSx pins mode as Input Tristate CMOS */  
  GPIO_Config (GPIO0, 0x0088, GPIO_IN_TRI_CMOS);
 
 /* BSPI0 Master configuration -----------------------------------------------*/

  /* Enable the BSPI0 interface */
  BSPI_BSPI0Conf (ENABLE);

  /* Initialize BSPI0 */
  BSPI_Init (BSPI0);

  /* Configure Baud rate Frequency: ---> APB1/6 */
  BSPI_ClockDividerConfig (BSPI0, 6);

  /* Configure BSPI0 as a Master */
  BSPI_MasterEnable (BSPI0, ENABLE);

  /* Configure the clock to be active high */
  BSPI_ClkActiveHigh (BSPI0, ENABLE);

  /* Enable capturing the first Data sample on the first edge of SCK */
  BSPI_ClkFEdge (BSPI0, DISABLE);

  /* Set the word length to 8 bit */
  BSPI_8bLEn (BSPI0, ENABLE);

  /*  Configure the depth of transmit to 9 words */
  BSPI_TrFifoDepth (BSPI0, 9);
  
    /* Enable BSPI0 */
  BSPI_Enable (BSPI0 , ENABLE);

 /*BSPI1 Slave configuration -------------------------------------------------*/
  
  /* Initialize BSPI1 */
  BSPI_Init (BSPI1) ;

  /* Configure Baud rate Frequency :-->APB1/8 */
  BSPI_ClockDividerConfig (BSPI1, 8);

  /* Enable BSPI1 */
  BSPI_Enable (BSPI1 , ENABLE);

  /* Configure BSPI1 as a Slave */
  BSPI_MasterEnable (BSPI1, DISABLE);

  /* Configure the clock to be active high */
  BSPI_ClkActiveHigh (BSPI1, ENABLE);

  /* Enable capturing the first Data sample on the first edge of SCK */
  BSPI_ClkFEdge (BSPI1, DISABLE);

  /* Set the word length to 8 bit */
  BSPI_8bLEn (BSPI1, ENABLE);

  /* Configure the depth of receive to 9 word */
  BSPI_RcFifoDepth (BSPI1, 9);

  /* Send nine words to BSPI1 */

  BSPI_ByteBufferSend (BSPI0, Sendtab, 9);

  /*Receive nine words from BSPI0*/

  BSPI_ByteBufferReceive (BSPI1, Receivetab, 9);
  
  /* Infinite loop */
  while (1)
  {
  }
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/


















