/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Main program body
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"
#include <stdio.h> 

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/*  Words to be transmitted */
u8 Sendtab[9] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09};
u8 Receivetab[9];

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
/*******************************************************************************
* Function Name  : main
* Description    : Main routine
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main (void)
{

  #ifdef DEBUG
  debug();
  #endif

  /* System clocks configuration ---------------------------------------------*/
  /* MCLK = PCLK1 = PCLK2 = 24MHz*/ 
  
  /* Configure PCLK1 = RCLK / 1 */
  RCCU_PCLK1Config (RCCU_DEFAULT);

  /* Configure PCLK2 = RCLK / 1 */
  RCCU_PCLK2Config (RCCU_DEFAULT);

  /* Configure MCLK clock for the CPU, RCCU_DEFAULT = RCLK /1 */
  RCCU_MCLKConfig (RCCU_DEFAULT);
   
  /* Configure the PLL1 ( * 12 , / 4 ) */
  RCCU_PLL1Config (RCCU_PLL1_Mul_12, RCCU_Div_4) ;

  while(RCCU_FlagStatus(RCCU_PLL1_LOCK) == RESET)
  {
    /* Wait PLL to lock */
  }
  /* Select PLL1_Output as RCLK clock */
  RCCU_RCLKSourceConfig (RCCU_PLL1_Output) ;
  
  /* Enable BSPI0 and BSPI1 clocks on APB1 */
  APB_ClockConfig (APB1,ENABLE, BSPI0_Periph | BSPI1_Periph );
  
  /* Enable GPIO0 clocks on APB1 */
  APB_ClockConfig (APB2,ENABLE, GPIO0_Periph);
  
  /* GPIO configuration ------------------------------------------------------*/
  /* Configure MOSIx, MISOx, and SCLKx pins as Alternate function Push Pull */
  GPIO_Config (GPIO0, 0x0077, GPIO_AF_PP);

  /* Configure nSSx pins mode as Input Tristate CMOS */  
  GPIO_Config (GPIO0, 0x0088, GPIO_IN_TRI_CMOS);
  

  /* BSPI1 Master configuration ----------------------------------------------*/

  /* Initialize BSPI1 */
  BSPI_Init(BSPI1);

  /* Configure BSPI1 Baud rate Frequency */
  BSPI_ClockDividerConfig (BSPI1, 6); 

  /* Configure BSPI1 as a Master */
  BSPI_MasterEnable(BSPI1, ENABLE);

  /* Configure the BSPI1 Clock Polarity */
  BSPI_ClkActiveHigh(BSPI1, ENABLE);

  /* Configure the BSPI1 Clock Phase */
  BSPI_ClkFEdge(BSPI1, ENABLE);

  /* Configure the word length */
  BSPI_8bLEn(BSPI1, ENABLE);

  /* Configure the transmit FIFO depth of BSPI1 */
  BSPI_TrFifoDepth(BSPI1, 9);
  
  /* Enable BSPI1 */
  BSPI_Enable(BSPI1, ENABLE);
  
  /* BSPI0 Slave configuration -----------------------------------------------*/
    
  /* Enable the BSPI0 interface */
  BSPI_BSPI0Conf(ENABLE);
  
  /* Initialize BSPI0 */
  BSPI_Init(BSPI0) ;

  /* Configure BSPI0 Baud rate Frequency */
  BSPI_ClockDividerConfig (BSPI0, 8);

  /* Configure BSPI0 as a Slave */
  BSPI_MasterEnable (BSPI0, DISABLE);

  /* Configure the BSPI0 Clock Polarity */
  BSPI_ClkActiveHigh(BSPI0, ENABLE);

  /* Configure the BSPI0 Clock Phase */
  BSPI_ClkFEdge(BSPI0, ENABLE);

  /* Configure the word length */
  BSPI_8bLEn(BSPI0, ENABLE);

  /* Configure the receive FIFO depth of BSPI0 */
  BSPI_RcFifoDepth(BSPI0, 9);
  
  /* Enable BSPI0 */
  BSPI_Enable (BSPI0, ENABLE);
  
  /* Configure the EIC channel interrupt */
  EIC_IRQChannelPriorityConfig(SPI0_IRQChannel, 1);
  EIC_IRQChannelConfig(SPI0_IRQChannel, ENABLE);
  EIC_IRQConfig(ENABLE);
  
  /* Configure the BSPI0 receive FIFO FUll interrupt */
  BSPI_RcItSrc(BSPI0,BSPI_RC_FF);

  /* Send 9 bytes from BSPI1 to BSPI0 */
  BSPI_ByteBufferSend(BSPI1, Sendtab, 9);
   
  /* Infinite loop */
  while (1)
  {
   }
}
  
/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/



