/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Main program body
********************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"
#include <stdio.h> 

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define UART0_Rx_Pin (0x0001<<8)  /*  TQFP 64: pin N 63 , TQFP 144 pin N 143 */
#define UART0_Tx_Pin (0x0001<<9)  /*  TQFP 64: pin N 64 , TQFP 144 pin N 144 */

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
u16 *address;
u16 i;

/* Private function prototypes -----------------------------------------------*/
void my_uart_config (void);

/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main routine
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main (void)
{
  #ifdef DEBUG
  debug();
  #endif
   
   /* System clocks configuration ---------------------------------------------*/
   /* MCLK = PCLK1 = PCLK2 = 8MHz*/ 
  
   /* Initialize address variable to address 0x62000000: bank1 base address of
     the External SRAM */
   address = (u16*)0x62000000;
   
   /* Enable GPIO2 clock on APB2 */
   APB_ClockConfig (APB2, ENABLE, GPIO2_Periph | GPIO0_Periph);
   
  /* Enable UART0 clock on APB1 */
   APB_ClockConfig (APB1, ENABLE, UART0_Periph);
   
   
   /* GPIO configuration -----------------------------------------------------*/
   /* configure P2.1, P2.4, P2.5, P2.6, P2.7 pins corresponding respectively to  
       CS.1, A20, A21, A22, A23 */
   GPIO_Config(GPIO2, 0xF2, GPIO_AF_PP);
   
   /* UART0 configuration for windows hyperterminal results display */
   my_uart_config ();
   
   /* EMI configuration ------------------------------------------------------*/
   /* Configure EMI bank 1 as follows: 
                             - 16-bit data length
                             - 15 wait states
   */
   EMI_Config (EMI_BANK1, EMI_SIZE_16, EMI_15_WaitStates);
   
   /* Enable EMI bank 1 */
   EMI_Enable (EMI_BANK1, ENABLE);
   
   /* Write 16 bytes in External SRAM from 0x62000000 address to 0x6200001F */
   for (i=0;i<16;i++)
   {
     *(address + i) = i;
   }

    /* Read and display these bytes from the same location to verify if the data  
      were written correctly */
    printf("\n\r- External SRAM content (BANK1 enabled):\n\r");
   
   /* Display the SRAM content from 0x62000000 to 0x6200001F */
   for (i=0;i<16;i++)
   { 
     printf("0x%X ",*(address + i));
   }
   
   printf("\n\r");
   
   /* Disable EMI bank 1 */
   EMI_Enable (EMI_BANK1, DISABLE);
   
   /* The EMI bank 1 is disabled so the data can not be read from bank 1*/
   printf("\n\r- External SRAM content (BANK1 disabled):\n\r");
   
   /* Display the SRAM content from 0x62000000 to 0x6200001F */
   for (i=0;i<16;i++)
   { 
     /* All bytes displayes should be 0x00 */
     printf("0x%X ", *(address+i));
   }
   
   /* Infinite loop */
   while (1)
   {
   }
     
}

/*******************************************************************************
* Function Name  : my_uart_config
* Description    : Configure the UART0 interface
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/ 
void my_uart_config (void)
{
 /*  Configure the GPIO pins */
  GPIO_Config(GPIO0, UART0_Tx_Pin, GPIO_AF_PP);
  GPIO_Config(GPIO0, UART0_Rx_Pin, GPIO_IN_TRI_CMOS);

  /* UART peripheral configuration -------------------------------------------*/

  /*  Configure the UART X */
  UART_OnOffConfig(UART0, ENABLE);       /*  Turn UARTX on */
  UART_FifoConfig (UART0, DISABLE);      /*  Disable FIFOs */
  UART_FifoReset  (UART0 , UART_RxFIFO); /*  Reset the UART_RxFIFO */
  UART_FifoReset  (UART0 , UART_TxFIFO); /*  Reset the UART_TxFIFO */
  UART_LoopBackConfig(UART0 , DISABLE);  /*  Disable Loop Back */
                                         /* Configure the UARTX as following:
                                            - Baudrate = 9600 Bps
                                            - No parity
                                            - 8 data bits
                                            - 1 stop bit */
  UART_Config(UART0,9600,UART_NO_PARITY,UART_1_StopBits,UARTM_8D);
  UART_RxConfig(UART0 ,ENABLE);          /*  Enable Rx */

}

/*******************************************************************************
* Function Name  : sendchar
* Description    : write a character to UART.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void sendchar( char *ch )
{
  UART_ByteSend(UART0,(u8 *)ch);
   if (*ch == 'n')                  
      *ch = '\r';
}

/*******************************************************************************
* Function Name  : fputc
* Description    : write a character to the UART.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int fputc(int ch, FILE *f)
{
    /* Place your implementation of fputc here */
    /* e.g. write a character to UART */

    char tempch = ch;
#ifdef USE_SERIAL_PORT
    sendchar( &tempch );
#endif
    return ch;
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/



