/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.h
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Main program body
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes-------------------------------------------------------------------*/
#include "i2c_ee.h"

/* Include of other module interface headers ---------------------------------*/
#include <stdio.h> 

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define EEPROM_WriteAddress    0x0
#define EEPROM_ReadAddress     0x0

#define UART0_Rx_Pin (0x0001<<8)  /*  TQFP 64: pin N 63 , TQFP 144 pin N 143 */
#define UART0_Tx_Pin (0x0001<<9)  /*  TQFP 64: pin N 64 , TQFP 144 pin N 144 */

#define BufferSize (countof(Tx_Data)-1)

/* Private macro -------------------------------------------------------------*/
#define countof(a) (sizeof(a) / sizeof(*(a)))

/* Private variables ---------------------------------------------------------*/
char  Tx_Data[]="STMicroelectronics \n\r       ** STR71x EEPROM Example **"; 
char  Rx_Data[BufferSize] = "";

/* Private function prototypes -----------------------------------------------*/
void my_uart_config (void);

/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main(void)
{
  #ifdef DEBUG
    debug();
  #endif
  
  /* System clocks configuration ---------------------------------------------*/
  /* MCLK = PCLK1 = PCLK2 = 24MHz*/ 
  
  /* Configure FCLK = RCLK / 1 */
  RCCU_PCLK1Config (RCCU_DEFAULT);

  /* Configure PCLK = RCLK / 1 */
  RCCU_PCLK2Config (RCCU_DEFAULT);

  /* Configure MCLK clock for the CPU, RCCU_DEFAULT = RCLK /1 */
  RCCU_MCLKConfig (RCCU_DEFAULT);
   
  /* Configure the PLL1 ( * 12 , / 4 ) */
  RCCU_PLL1Config (RCCU_PLL1_Mul_12, RCCU_Div_4) ;

  while(RCCU_FlagStatus(RCCU_PLL1_LOCK) == RESET)
  {
    /* Wait PLL to lock */
  }
  
  /* Select PLL1_Output as RCLK clock */
  RCCU_RCLKSourceConfig (RCCU_PLL1_Output) ;
  
  /* Enable I2C0 clock on APB1 */
  APB_ClockConfig (APB1, ENABLE, I2C0_Periph | UART0_Periph );
  
  /* Enable GPIO1 clock on APB2 */
  APB_ClockConfig (APB2, ENABLE, GPIO1_Periph | GPIO0_Periph );
 
  /* UART0 configuration for windows hyperterminal results display */
  my_uart_config ();
  
  /* Configure I2C0 interface */
  I2C_EEPROM_Config(I2C0);
  
  /* Write the Tx_Buffer on I2C0 EEPROM starting from address 0x5 */
  EEPROM_BufferWrite(I2C0, Tx_Data, EEPROM_WriteAddress, BufferSize);

  /* Read Buffer from the M24C08 */
  EEPROM_Receive(I2C0, Rx_Data, EEPROM_ReadAddress, BufferSize);
   
  /* Print RX buffer */
  printf("Rx_Buffer : %s\r\n", Rx_Data);
   
  while(1)
  {
  }  
}

/*******************************************************************************
* Function Name  : my_uart_config
* Description    : Configure the UART0 interface
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/ 
void my_uart_config (void)
{
 /*  Configure the GPIO pins */
  GPIO_Config(GPIO0, UART0_Tx_Pin, GPIO_AF_PP);
  GPIO_Config(GPIO0, UART0_Rx_Pin, GPIO_IN_TRI_CMOS);

  /* UART peripheral configuration -------------------------------------------*/

  /*  Configure the UART X */
  UART_OnOffConfig(UART0, ENABLE);       /*  Turn UARTX on */
  UART_FifoConfig (UART0, DISABLE);      /*  Disable FIFOs */
  UART_FifoReset  (UART0 , UART_RxFIFO); /*  Reset the UART_RxFIFO */
  UART_FifoReset  (UART0 , UART_TxFIFO); /*  Reset the UART_TxFIFO */
  UART_LoopBackConfig(UART0 , DISABLE);  /*  Disable Loop Back */
                                         /* Configure the UARTX as following:
                                            - Baudrate = 9600 Bps
                                            - No parity
                                            - 8 data bits
                                            - 1 stop bit */
  UART_Config(UART0,9600,UART_NO_PARITY,UART_1_StopBits,UARTM_8D);
  UART_RxConfig(UART0 ,ENABLE);          /*  Enable Rx */

}

/*******************************************************************************
* Function Name  : sendchar
* Description    : write a character to UART.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void sendchar( char *ch )
{  
  UART_ByteSend(UART0,(u8 *)ch);
   if (*ch == 'n')                  
      *ch = '\r';
}

/*******************************************************************************
* Function Name  : fputc
* Description    : write a character to the UART.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int fputc(int ch, FILE *f)
{
    /* Place your implementation of fputc here */
    /* e.g. write a character to UART */

    char tempch = ch;
#ifdef USE_SERIAL_PORT
    sendchar( &tempch );
#endif
    return ch;
}



/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/
