/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Main program body
********************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define T3_OCMP_A            0x04

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name      : main
* Description        : main routine
* Input              : None.
* Return             : None.
*******************************************************************************/
int main(void)
{
  #ifdef DEBUG
  debug();
  #endif

     
  /* Enable TIM3, GPIO0 and GPIO1 clocks on APB2 */
  APB_ClockConfig (APB2, ENABLE, TIM3_Periph  GPIO0_Periph | GPIO1_Periph);
  
  /* GPIO configuration ------------------------------------------------------*/

  /*  Timer 3 Output Compare function pin (P1.2) configured as Alternate
      function pushpull */
  GPIO_Config (GPIO1, T3_OCMP_A, GPIO_AF_PP);

  /*  GPIO port configured as output push pull */
  GPIO_Config (GPIO0, 0xFFFF, GPIO_OUT_PP);

  /*  Initialise the GPIO0 port to low level */
  GPIO_WordWrite(GPIO0, 0x0000);
 
  /* EIC configuration -------------------------------------------------------*/

  /*  Enable the IRQ0 for timer 3 */
  EIC_IRQChannelConfig(T3TIMI_IRQChannel, ENABLE );
  EIC_IRQChannelPriorityConfig(T3TIMI_IRQChannel, 1);
  EIC_IRQConfig(ENABLE);

  
  /* TIM3 configuration ------------------------------------------------------*/
  /*  Initialize the Timer 3 registers to reset values */
  TIM_Init (TIM3);

  /*  Configure the TIM Prescaler */
  TIM_PrescalerConfig (TIM3, 0x7F);

  /*  Enable the Output Compare for the TIM3 peripheral */
  TIM_ITConfig (TIM3, TIM_OCA_IT, ENABLE);

  /*  Configure the TIM3 Output Compare Function */
  TIM_OCMPModeConfig (TIM3, TIM_CHANNEL_A, 0xA000, TIM_WAVE, TIM_HIGH);
  /*                     |       |             |        |         |
                TIM 3 <--+       |             |        |         +--> Toggle To
                                 |             |        |              High Level
      TIM 3 Output compare       |             |        |
         channelA             <--+             |        +--> OCMP function used for
                                               |             external wave generation.
       Delay before toggling <-----------------+                                  */

  /* GPIO0 Forced To high Level */
   GPIO_WordWrite(GPIO0, 0xFFFF);

  /*  Infinite loop */
  while (1)
  {
  /*  Infinite loop */
  }
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/
