/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Main program body
********************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define T3_OCMP_A            0x04

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name      : main
* Description        : main routine
* Input              : None.
* Return             : None.
*******************************************************************************/
int main(void)
{
  #ifdef DEBUG
  debug ();
  #endif

  /* System clocks configuration ---------------------------------------------*/
  /* MCLK = PCLK1 = PCLK2 = 8MHz*/ 
     
  /* Enable TIM3 and GPIO1 clocks on APB2 */
  APB_ClockConfig (APB2, ENABLE, TIM3_Periph | GPIO1_Periph);
  
  /* GPIO1 configuration -----------------------------------------------------*/
  /* Timer 3 Output Compare function pin (P1.2) configured as Alternate
      function pushpull. */
   GPIO_Config (GPIO1, T3_OCMP_A, GPIO_AF_PP);

  /* TIM configuration -------------------------------------------------------*/
  /* Initialize the Timer */
  TIM_Init (TIM3);

  /* Configure the TIM Prescaler */
  TIM_PrescalerConfig (TIM3, 0x1);

  /* Generate a PWM Signal :
       - Full Period  = 7FFF
       - Duty Cycle   = 50 % ( 3FFF ) */
  TIM_PWMOModeConfig (TIM3, 0x3FFF, TIM_HIGH, 0x7FFF, TIM_LOW);

  /* Start The Counter */
  TIM_CounterConfig (TIM3, TIM_START);

  
  while (1)
  {
  /* Infinite loop */
  }
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/
