/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Main program body
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define UART0_Rx_Pin (0x0001 << 8)  /*TQFP 64: pin N 63, TQFP 144 pin N 143*/
#define UART0_Tx_Pin (0x0001 << 9)  /*TQFP 64: pin N 64, TQFP 144 pin N 144*/

#define MESSAGE1 "\n\rPlease select FIFO interrupt source:\n\r\
Press: 1 for Rx half full\n\r\
       2 for Rx buffer not empty\n\r"

#define MESSAGE2 "Please send characters\n\r"
#define MESSAGE3 "Please type 8 characters\n\r"

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
u8 DATA8;
u8 Data_recieve_status=0;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main (void)
{
  
 #ifdef DEBUG
  debug();
 #endif /* DEBUG */ 

  /* System clocks configuration ---------------------------------------------*/
  /* MCLK =24 MHz and  PCLK1 = PCLK2 = 12MHz*/ 
  
   /* Configure PCLK1 = RCLK / 2 */
  RCCU_PCLK1Config (RCCU_RCLK_2);

  /* Configure PCLK2 = RCLK / 2 */
  RCCU_PCLK2Config (RCCU_RCLK_2);

  /* Configure MCLK clock for the CPU, RCCU_DEFAULT = RCLK /1 */
  RCCU_MCLKConfig (RCCU_DEFAULT);
   
  /* Configure the PLL1 ( * 12 , / 4 ) */
  RCCU_PLL1Config (RCCU_PLL1_Mul_12, RCCU_Div_4) ;

  while(RCCU_FlagStatus(RCCU_PLL1_LOCK) == RESET)
  {
    /* Wait PLL to lock */
  }
  /* Select PLL1_Output a s RCLK clock */
  RCCU_RCLKSourceConfig (RCCU_PLL1_Output);  
  
  /* Enable UART0 clock on APB1 */
  APB_ClockConfig (APB1, ENABLE, UART0_Periph);
  
  /* Enable EIC and GPIO0 clocks on APB2 */
  APB_ClockConfig (APB2, ENABLE, EIC_Periph | GPIO0_Periph);

  /* GPIO configuration ------------------------------------------------------*/
  /* Configure the GPIO pins */
  GPIO_Config(GPIO0, UART0_Tx_Pin, GPIO_AF_PP);
  GPIO_Config(GPIO0, UART0_Rx_Pin, GPIO_IN_TRI_CMOS);
  
  /* UART configuration ------------------------------------------------------*/
  /* Initialize UART0 */
  UART_Init(UART0);
  
  /* Disable UART0 Loop Back */ 
  UART_LoopBackConfig(UART0, DISABLE);
  
  /* Disable UART0 FIFOs */      
  UART_FifoConfig (UART0, DISABLE);
  
  /* Enable UART0 */
  UART_OnOffConfig(UART0, ENABLE); 
  
  /* Enable recieve on UART0 */
  UART_RxConfig(UART0, ENABLE);                                            
 
  /* Configure the UART0 as following:
                              - Baudrate = 9600 Bps
                              - No parity
                              - 8 data bits
                              - 1 stop bit */
  UART_Config(UART0, 9600, UART_NO_PARITY, UART_1_StopBits, UARTM_8D);
  
  /* Send MESSAGE1 defined above over UART0 */
  UART_StringSend(UART0,MESSAGE1);
  
  /* Polling on a received character (typed by a user on hyperterminal) */
  while(!(UART_FlagStatus(UART0) & UART_RxBufNotEmpty))
  {
    /* Wait for a received character */
  }
  
  /* Read the received character and put it in DATA8 */
  UART_ByteReceive(UART0, (u8 *)&DATA8 , 0xFF);
  
  /* Send the received character */
  UART_ByteSend(UART0, (u8 *)&DATA8);
  
  /* Send End of String and Carriage Return characters */
  UART_DataSend(UART0,"\n\r", sizeof("\n\r"));
  
  /* Remain in the loop while the received character is different from 1 or 2 */
  while((DATA8 != '1') && (DATA8 != '2')) 
  {
    /* If the pressed key is different from 1 or 2, always ask the
       user to press 1 or 2 to select the interruption source */   
    UART_DataSend(UART0,MESSAGE1, sizeof(MESSAGE1));
    
    /* Polling on a received character */
    while(!(UART_FlagStatus(UART0) & UART_RxBufNotEmpty))
    {
      /* Wait for a received character */
    }
    
    /* Get the received character */
    UART_ByteReceive(UART0, (u8 *)&DATA8, 0xFF);
  }
  
  /* Configure the EIC channel interrupt */
  EIC_IRQChannelPriorityConfig(UART0_IRQChannel, 1);
  EIC_IRQChannelConfig(UART0_IRQChannel, ENABLE);
  EIC_IRQConfig(ENABLE);
  
  /* Enable the UART0 Fifo */
  UART_FifoConfig (UART0, ENABLE);
  
  /* Reset the UART0_RxFIFO */ 
  UART_FifoReset (UART0 , UART_RxFIFO);
  
  /* If the user has pressed key '1' */  
  if(DATA8=='1')
  {
    /* Configure the interruption source as UART0 RX FIFO Half Full */
    UART_ItConfig(UART0, UART_RxHalfFull, ENABLE);
    
    /* Send MESSAGE3  */ 
    UART_DataSend(UART0, MESSAGE3 , sizeof(MESSAGE3)); 
  }
  
  /* If the user has pressed key '2' */
  else
  {
    /* Configure the interruption source as UART0 RX Buffer Not Empty */
    UART_ItConfig(UART0, UART_RxBufNotEmpty, ENABLE);
    
    /* Send MESSAGE2 */ 
    UART_DataSend(UART0, MESSAGE2 , sizeof(MESSAGE2)); 
  }
 
  while(1)
  {
    /* Infinite Loop*/
  }
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/



