/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V4.0
* Date               : 10/09/2007
* Description        : Main program body
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "71x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define UART0_Rx_Pin (0x0001 << 8)  /*TQFP 64: pin N 63, TQFP 144 pin N 143*/
#define UART0_Tx_Pin (0x0001 << 9)  /*TQFP 64: pin N 64, TQFP 144 pin N 144*/

#define UART1_Rx_Pin (0x0001 << 10) /* TQFP 64: pin N 1, TQFP 144 pin N 1*/
#define UART1_Tx_Pin (0x0001 << 11) /* TQFP 64: pin N 2, TQFP 144 pin N 3*/

#define UART2_Rx_Pin (0x0001 << 13) /* TQFP 64: pin N 5, TQFP 144 pin N 9*/
#define UART2_Tx_Pin (0x0001 << 14) /* TQFP 64: pin N 6, TQFP 144 pin N 10*/

#define UART3_Rx_Pin (0x0001 << 1)  /* TQFP 64: pin N 52, TQFP 144 pin N 123*/
#define UART3_Tx_Pin (0x0001 << 0)  /* TQFP 64: pin N 53, TQFP 144 pin N 124*/

#define Use_UART0
/* #define Use_UART1 */
/* #define Use_UART2 */
/* #define Use_UART3 */

#ifdef Use_UART0
  #define  UARTX  UART0
  #define  UARTX_Rx_Pin  UART0_Rx_Pin
  #define  UARTX_Tx_Pin  UART0_Tx_Pin
  #define  UARTX_Periph  UART0_Periph
#endif /* Use_UART0 */

#ifdef Use_UART1
  #define  UARTX  UART1
  #define  UARTX_Rx_Pin  UART1_Rx_Pin
  #define  UARTX_Tx_Pin  UART1_Tx_Pin
  #define  UARTX_Periph  UART1_Periph
#endif /* Use_UART1 */

#ifdef Use_UART2
  #define  UARTX  UART2
  #define  UARTX_Rx_Pin  UART2_Rx_Pin
  #define  UARTX_Tx_Pin  UART2_Tx_Pin
  #define  UARTX_Periph  UART2_Periph
#endif /* Use_UART2 */

#ifdef Use_UART3
  #define  UARTX  UART3
  #define  UARTX_Rx_Pin  UART3_Rx_Pin
  #define  UARTX_Tx_Pin  UART3_Tx_Pin
  #define  UARTX_Periph  UART3_Periph
#endif /* Use_UART3 */

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
u16 i;
u16 UARTStatus;
u8 bBuffer[4] = {'S', 'T', 'R', '7'};

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main(void)
{
  #ifdef DEBUG
  debug();
  #endif
 
  /* System clocks configuration ---------------------------------------------*/
  /* MCLK = PCLK1 = PCLK2 = 24MHz*/ 
  
  /* Configure FCLK = RCLK / 1 */
  RCCU_PCLK1Config (RCCU_DEFAULT);

  /* Configure PCLK = RCLK / 1 */
  RCCU_PCLK2Config (RCCU_DEFAULT);

  /* Configure MCLK clock for the CPU, RCCU_DEFAULT = RCLK /1 */
  RCCU_MCLKConfig (RCCU_DEFAULT);
   
  /* Configure the PLL1 ( * 12 , / 4 ) */
  RCCU_PLL1Config (RCCU_PLL1_Mul_12, RCCU_Div_4) ;

  while(RCCU_FlagStatus(RCCU_PLL1_LOCK) == RESET)
  {
    /* Wait PLL to lock */
  }
  /* Select PLL1_Output as RCLK clock */
  RCCU_RCLKSourceConfig (RCCU_PLL1_Output) ;  
  
  /* Enable UART0 clock on APB1 */
  APB_ClockConfig (APB1, ENABLE, UART0_Periph | UART1_Periph
                    | UART2_Periph | UART3_Periph);
 
  /* Enable GPIO0 clock on APB2 */
  APB_ClockConfig (APB2, ENABLE, GPIO0_Periph );
  
  /* GPIO configuration ------------------------------------------------------*/

  /*  Configure the GPIO pins */
  GPIO_Config(GPIO0, UARTX_Tx_Pin, GPIO_AF_PP);
  GPIO_Config(GPIO0, UARTX_Rx_Pin, GPIO_IN_TRI_CMOS);
  
 
  /* UART configuration ------------------------------------------------------*/
  /*  Turn UARTX on */
  UART_OnOffConfig(UARTX, ENABLE); 
  
  /*  Disable FIFOs */      
  UART_FifoConfig (UARTX, DISABLE); 
  
  /*  Reset the UART_RxFIFO */     
  UART_FifoReset  (UARTX , UART_RxFIFO); 
  
  /*  Reset the UART_TxFIFO */
  UART_FifoReset  (UARTX , UART_TxFIFO); 
  
  /*  Disable Loop Back */
  UART_LoopBackConfig(UARTX , DISABLE);                                           
 /* Configure the UARTX as following:
                             - Baudrate = 9600 Bps
                             - No parity
                             - 8 data bits
                             - 1 stop bit */
  UART_Config(UARTX, 9600, UART_NO_PARITY, UART_1_StopBits, UARTM_8D);
  
  /*  Enable Rx */
  UART_RxConfig(UARTX ,ENABLE); 
           
  while(1)
  {
    for(i = 0; i < 4; i++)
    {
      UART_ByteSend(UARTX, (u8 *)&bBuffer[i]);
      
      while(!((UART_FlagStatus(UARTX)) & UART_TxEmpty))
      {
      /* wait until the data transmission is finished */
      } 
    }

    for(i = 0; i < 4; i++)
    {
             
      while(!(UART_FlagStatus(UARTX) & UART_RxBufNotEmpty))
      {
      /* wait until data is received */
      }  
      /*  Get the received data, set the guard time to 0xFF */
      UARTStatus = UART_ByteReceive(UARTX, (u8 *)&bBuffer[i], 0xFF); 
    }
   }
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/
