/* C support file for DSPLIB in IAR environment */

#include <stdio.h>
#include "91x_dsp.h"

extern void fft_16_arm9e(void *y, void *x, unsigned int N);
extern void cr4fft1k16_arm9e(void *pssOUT, void *pssIN, int nBin);
//extern void arm_fir_b4(void *y, void *x, void *h, int nh, int ny);
extern void fir_b4r_arm9e(short *y, short *x, short *h, int nh, int ny);

char lib_name[NAME_LEN] = "str91x_dsp";

/* ----------- -------------- -------------- */
struct complex_fft *str91x_DSP_INIT()
{
  int i = 0;
  static struct complex_fft str91x_dsp;

  for (i = 0; i < NAME_LEN; i++)
    str91x_dsp.name[i] = lib_name[i];
//  memcpy(str91x_dsp.name, "str91x_dsp", 10);
  str91x_dsp.calc_cr4fft_1k = cr4fft1k16_arm9e;
//  str91x_dsp.calc_cr4fft_4k = fft_16_arm9e;
  return &str91x_dsp;
}
