/* Header support file for DSPLIB in IAR environment */

#define  NAME_LEN  10

struct complex_fft
{
	char	name[NAME_LEN];	/* dsp_str91x */
	void	(*calc_cr4fft_1k)(void *output, void *input, int num);	/* mode = FFTs input/ouput array addresses : length */
/*        void	(*calc_fft_16_arm9e)(void *output, void *input, int num); */
        void	(*calc_cr4fft_4k)(void *output, void *input, unsigned int num);
/*	void 	(*calculate_fir)(...........); */

/*	void 	(*calculate_iir)(...........); */
/*	int	(*read)(char *output);	   */
};

struct complex_fft *str91x_DSP_INIT();

/* for block FIR module */
typedef struct coefs{
  short *h;
  unsigned int nh;
} nh;

void fir_16by16_arm9e(void *y, void *x, nh *p, int ny);
/* end for block FIR module */

/* for IIR ARMA filter */
void iirarma_arm9e
              (
                void      *y,       /* Output array */
                void      *x,       /* Input array */
                short     *h2,      /* AR part Filter Coefficients */
                short     *h1,      /* FIR part Filter Coefficients */
                int        ny       /* Number of output samples */
              );
/* end for IIR ARMA filter */
