/* --------------------------------------------------------------- */
/* This is Main program for ARMA IIR filter implementation         */
/* for ARM9E validated in IAR/STR91x environment                   */
/* and the module is presented "as is with no warranty".           */
/* --------------------------------------------------------------- */

#include <math.h>
#include "../../../str91x/globals.h"
#include "../../../str91x/lcd.h"
#include "../../../dsp/91x_dsp.h"

void MyDualSweep(ulong freqinc1,ulong freqinc2);
void In_displayWaveform(char *strView);
void Out_displayWaveform(char *strView);

/* ****************************************** */
#define SIZE 512           /* Number of output samples */
ulong ani,loop=0;
ulong time, delay ;

long lBUFIN[1*(SIZE+4)];  /* Input vector */
long lBUFOUT[1*SIZE];     /* Output vector */
long lBUFMAG[1*SIZE];     /* Magnitude vector */

void gSin(long nfill, long Fs, long Freq1, long Freq2, long Ampli);
void MygSin(long nfill, long Fs, long Freq1, long Freq2, long Ampli);
void powerMag(long nfill, char* strPara);

unsigned char bmpout,bmpout0,bmpout1;
ushort cln;

short h2[5] = { 0x09c2,  0x270a,  0x3a8f,  0x270a,  0x09c2 };
short h1[5] = { 0x7fff,  0xd24a,  0x72ca,  0xcf4e,  0x1ad4 };

/* ****************************************** */
void MyDualSweep(ulong freqinc1,ulong freqinc2)
{
ulong freq;
  while (loop == 0)
  {
  for (freq=0; freq <4000; freq+=freqinc1)
  {
    MygSin(64, 8000, freq, 0, 32767);
    iirarma_arm9e(lBUFOUT, lBUFIN, h2, h1, SIZE);
/*    powerMag(64,"2SIDED"); */
    init_display();
    In_displayWaveform("TOPLEFT");
    Out_displayWaveform("BOTLEFT");
/*    displayPowerMag("BOTLEFT"); */
    for (delay=0; delay < 1000*MILLISEC; delay++) ani=ani;
    }

  for (freq=400; freq <2000; freq+=freqinc2)
  {
    gSin(64, 8000, freq, 0, 32767);
    iirarma_arm9e(lBUFOUT, lBUFIN, h2, h1, SIZE);
/*    powerMag(64,"2SIDED"); */
    In_displayWaveform("TOPRIGHT");
    Out_displayWaveform("BOTRIGHT");
/*    displayPowerMag("BOTRIGHT"); */
    for (delay=0; delay < 1000*MILLISEC; delay++) ani=ani;
    }
  } /* while */
}

/* used as input signal */
void MygSin(long nfill, long Fs, long Freq1, long Freq2, long Ampli)
{
 ulong i;
 float fFs, fFreq1, fFreq2, fAmpli;
 float fZ,fY;

 fFs = (float) Fs;
 fFreq1 = (float) Freq1;
 fFreq2 = (float) Freq2;
 fAmpli = (float) Ampli;

 for (i=0; i < nfill; i++)
 {
     fY = sin(PI2 * i * (fFreq1/fFs)) + sin(PI2 * i * (fFreq2/fFs));
     fZ = fAmpli * fY;
     lBUFIN[i]= ((short)fZ) << 16 ;  /* sine_cosine  (cos=0x0) */
 }
}

void gSin(long nfill, long Fs, long Freq1, long Freq2, long Ampli)
{
 ulong i;
 float fFs, fFreq1, fFreq2, fAmpli;
 float fZ,fY;

 fFs = (float) Fs;
 fFreq1 = (float) Freq1;
 fFreq2 = (float) Freq2;
 fAmpli = (float) Ampli;

 for (i=0; i < nfill; i++)
 {
     fY = sin(PI2 * i * (fFreq1/fFs)) + sin(PI2 * i * (fFreq2/fFs));
     fZ = fAmpli * fY;
     lBUFIN[i]= ((short)fZ) << 16 ;  /* sine_cosine  (cos=0x0) */
 }
}

void onesided(long nfill)
{
     lBUFMAG[0] = lBUFMAG[0];
     lBUFMAG[nfill/2] = lBUFMAG[nfill/2];
     for (ulong i=1; i < nfill/2; i++)
      { lBUFMAG[i] = lBUFMAG[i] + lBUFMAG[nfill-i]; lBUFMAG[nfill-i] = 0x0;   }
}

void powerMag(long nfill, char* strPara)
{
 long lX,lY;

 for (ulong i=0; i < nfill; i++)
 {
     lX= (lBUFOUT[i]<<16)>>16; /* sine_cosine --> cos */
     lY= (lBUFOUT[i] >> 16);   /* sine_cosine --> sin */
     float X=  64*((float)lX)/32768;
     float Y = 64*((float)lY)/32768;
     float Mag = sqrt(X*X+ Y*Y)/nfill;
     lBUFMAG[i] = (ulong)(Mag*65536);
 }
 if (strPara == "1SIDED") onesided(nfill);
}

/*  ************ DRIVER\LCD\MAIN.C ***************  */
void init_display(void)
{
  LCD_Config();
  ClrScr();
  mode = 0;  ulayer = 0;  ucol = 0;		
}

void displayTitle(void)
{
  LCD_Printf(0, " ARMA IIR Demo " );	
  ucol = 0;
  LCD_Printf(1, " STR91x ARM966E-S " );
 }

void In_displayWaveform(char* stView)
{
char aScale;
  for (cln=0; cln <= 64; cln++)       /* original upper limit was 60 */
    {
      aScale = lBUFIN[cln]>>(12 + 16);  /* SINE IS LEFT ALIGNED */
      aScale &=0xF; /* 4-bit switch */
      switch(aScale)
        {
       case 0xF : bmpout1=0x01; bmpout0=0x00;break;
       case 0xE : bmpout1=0x03; bmpout0=0x00;break;
       case 0xD : bmpout1=0x07; bmpout0=0x00;break;
       case 0xC : bmpout1=0x0F; bmpout0=0x00;break;
       case 0xB : bmpout1=0x1F; bmpout0=0x00;break;
       case 0xA : bmpout1=0x3F; bmpout0=0x00;break;
       case 0x9 : bmpout1=0x7F; bmpout0=0x00;break;
       case 0x8 : bmpout1=0xFF; bmpout0=0x00;break;
       case 0x7 : bmpout1=0x00; bmpout0=0xFF;break;
       case 0x6 : bmpout1=0x00; bmpout0=0xFE;break;
       case 0x5 : bmpout1=0x00; bmpout0=0xFC;break;
       case 0x4 : bmpout1=0x00; bmpout0=0xF8;break;
       case 0x3 : bmpout1=0x00; bmpout0=0xF0;break;
       case 0x2 : bmpout1=0x00; bmpout0=0xE0;break;
       case 0x1 : bmpout1=0x00; bmpout0=0xC0;break;
       case 0x0 : bmpout1=0x00; bmpout0=0x80; break;
       }/* switch */
      if (stView=="TOPLEFT")  { DrawBmpP1(cln,0,1,&bmpout1); DrawBmpP0(cln,0,1,&bmpout0);}
      if (stView=="BOTLEFT")  { DrawBmpP3(cln,0,1,&bmpout1); DrawBmpP2(cln,0,1,&bmpout0);}
      if (stView=="TOPRIGHT") { DrawBmpSP1(cln,0,1,&bmpout1); DrawBmpSP0(cln,0,1,&bmpout0);}
      if (stView=="BOTRIGHT") { DrawBmpSP3(cln,0,1,&bmpout1); DrawBmpSP2(cln,0,1,&bmpout0);}
    }/* for */
}

void Out_displayWaveform(char* stView)
{
char aScale;
  for (cln=0; cln <= 64; cln++)       /* original upper limit was 60 */
    {
      aScale = lBUFOUT[cln]>>(12 + 16);  /* SINE IS LEFT ALIGNED */
      aScale &=0xF; /* 4-bit switch */
      switch(aScale)
        {
       case 0xF : bmpout1=0x01; bmpout0=0x00;break;
       case 0xE : bmpout1=0x03; bmpout0=0x00;break;
       case 0xD : bmpout1=0x07; bmpout0=0x00;break;
       case 0xC : bmpout1=0x0F; bmpout0=0x00;break;
       case 0xB : bmpout1=0x1F; bmpout0=0x00;break;
       case 0xA : bmpout1=0x3F; bmpout0=0x00;break;
       case 0x9 : bmpout1=0x7F; bmpout0=0x00;break;
       case 0x8 : bmpout1=0xFF; bmpout0=0x00;break;
       case 0x7 : bmpout1=0x00; bmpout0=0xFF;break;
       case 0x6 : bmpout1=0x00; bmpout0=0xFE;break;
       case 0x5 : bmpout1=0x00; bmpout0=0xFC;break;
       case 0x4 : bmpout1=0x00; bmpout0=0xF8;break;
       case 0x3 : bmpout1=0x00; bmpout0=0xF0;break;
       case 0x2 : bmpout1=0x00; bmpout0=0xE0;break;
       case 0x1 : bmpout1=0x00; bmpout0=0xC0;break;
       case 0x0 : bmpout1=0x00; bmpout0=0x80; break;
       }/* switch */
      if (stView=="TOPLEFT")  { DrawBmpP1(cln,0,1,&bmpout1); DrawBmpP0(cln,0,1,&bmpout0);}
      if (stView=="BOTLEFT")  { DrawBmpP3(cln,0,1,&bmpout1); DrawBmpP2(cln,0,1,&bmpout0);}
      if (stView=="TOPRIGHT") { DrawBmpSP1(cln,0,1,&bmpout1); DrawBmpSP0(cln,0,1,&bmpout0);}
      if (stView=="BOTRIGHT") { DrawBmpSP3(cln,0,1,&bmpout1); DrawBmpSP2(cln,0,1,&bmpout0);}
    }/* for */
}

void displayPowerMag(char *stView)
{
char aScale;

  for (cln=0; cln <= 60; cln++)
    {
      aScale =lBUFMAG[cln]>>11 ; /* spectrum is always divided by two */
      if (aScale > 0xF) aScale = 0xF; /* if ever */
      aScale &=0xF; /* 4-bit switch */
      switch(aScale)
        {
       case 0xF : bmpout1=0xFF; bmpout0=0xFF;break;
       case 0xE : bmpout1=0xFF; bmpout0=0xFE;break;
       case 0xD : bmpout1=0xFF; bmpout0=0xFC;break;
       case 0xC : bmpout1=0xFF; bmpout0=0xF8;break;
       case 0xB : bmpout1=0xFF; bmpout0=0xF0;break;
       case 0xA : bmpout1=0xFF; bmpout0=0xE0;break;
       case 0x9 : bmpout1=0xFF; bmpout0=0xC0;break;
       case 0x8 : bmpout1=0xFF; bmpout0=0x80;break;
       case 0x7 : bmpout1=0xFF; bmpout0=0x00;break;
       case 0x6 : bmpout1=0xFE; bmpout0=0x00;break;
       case 0x5 : bmpout1=0xFC; bmpout0=0x00;break;
       case 0x4 : bmpout1=0xF8; bmpout0=0x00;break;
       case 0x3 : bmpout1=0xF0; bmpout0=0x00;break;
       case 0x2 : bmpout1=0xE0; bmpout0=0x00;break;
       case 0x1 : bmpout1=0xC0; bmpout0=0x00;break;
       case 0x0 : bmpout1=0x80; bmpout0=0x00; break;
       }/* switch */
      if (stView=="TOPLEFT")  { DrawBmpP1(cln,0,1,&bmpout1); DrawBmpP0(cln,0,1,&bmpout0);}
      if (stView=="BOTLEFT")  { DrawBmpP3(cln,0,1,&bmpout1); DrawBmpP2(cln,0,1,&bmpout0);}
      if (stView=="TOPRIGHT") { DrawBmpSP1(cln,0,1,&bmpout1); DrawBmpSP0(cln,0,1,&bmpout0);}
      if (stView=="BOTRIGHT") { DrawBmpSP3(cln,0,1,&bmpout1); DrawBmpSP2(cln,0,1,&bmpout0);}
    }/* for */
}

/* main function */
int main(void)
{
  LCD_Config();
  for (time=0; time <12000; time+=125) { displayTitle(); }
  MyDualSweep(40,25);

  return 0;
}
/* end of main function */
