////////////////////////////////////////////////////////////////////
// DSPLIB\FFTtest\GLOBALS.H * Globals
// 1.1 <06DEC05> creation - copied from FFT project- simplified version
////////////////////////////////////////////////////////////////////
#ifndef GLOBALS_H
#define GLOBALS_H
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <math.h>


// Data types/////////////////////////////////////////////////////////
//Constants and Types
typedef double real;
typedef struct { real re,im; } complex;

typedef signed char int8;
typedef short int16;
typedef unsigned short uint16;
typedef unsigned short ushort;
typedef long int32;
typedef unsigned long uint32;
typedef unsigned long ulong;
typedef signed long sint32;
typedef long long int64;
typedef unsigned long long uint64;
typedef signed long long sint64;
typedef enum
{
  q13in32 = (13<<16)|32,
  q13in16 = (13<<16)|16,
  q14in32 = (14<<16)|32,
  q14in16 = (14<<16)|16,
  q15in32 = (15<<16)|32,
  q15in16 = (15<<16)|16,
  q26in32 = (26<<16)|32,
  q29in32 = (29<<16)|32,
  q58in64 = (58<<16)|64,
  tend
} format;
#define QSHIFT(type) (type>>16)
#define TSIZE(type) (type & 0xFF)
//Functions and Variables

//////  GLOBAL ACTORS  ////////////////////////////////
// put in main


//GENE GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG//
//Constants and Types
//Functions and Variables
void *gen_data(int size, format type, real *ref);


//PARA PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP//
//empty

// DUT MANAGER = ARM DATAPATH ///////////////////////////////////////////
//Constants and Types
#define PI2  6.28318530717959
//#define PI   3.14159265
#define PI  (3.141592654)

typedef struct { void *pX;  void *pK; int NIN; } strucFFT;
//
typedef void fn_fft2(void *pssA, void *pssB);
typedef void fn_fft3(void *pssOUT, void *pssIN, int nBin);
typedef void fn_fft4(void *pssOUT, void *pssIN, strucFFT *strucF, int extension);

//Functions and Variables
fn_fft3 fftQ_ROM_ARM9E;

fn_fft2 fft64Q_ROM_ARM9E;
fn_fft2 fft256Q_ROM_ARM9E;
fn_fft2 fft64Q_PBR_ARM9E;
fn_fft2 fft64Q_PRPT_ARM9E;

fn_fft4 fftQ_VARK_ARM9E;

//BUFFER MANAGER /////////////////////////////
//Constants and Types
//Functions and Variables
real *gen_signal(int size, int code);
void gen_fft_tables(int N, int arch);
void *my_malloc(int size);
void free_signal(void *data);
//assembler
void copyTableK(long *pssBUF, int nWords);
long *getAddressTableK(void);

//CHECKER MANAGER ///////////////////////////////////
//Constants and Types
//Functions and Variables
int compare(real *ref, void *data, format type, int size, int maxerr);


//DISPLAY MANAGER ///////////////////////////////////
//Constants and Types
#define SECONDS  (0x50000)
#define MILLISEC (0x50)
//Functions and Variables
void init_display(void);
void displayPowerMag(char *stView);
void displayWaveform(char *strView);
void displayTitle(void);


/////////////////////////////////////////////////

#endif
