//------------------------------------------------------------------------------
//lcd.h
//Version: February 2006 Version 2.0
//Dependencies: None
//Description: function prototypes for those used in the/LCD driver (lcd.c).
//------------------------------------------------------------------------------
#ifndef __LCD_H
#define __LCD_H

#define SOFTWARE_RESET         (0XE2)
#define DISPLAY_OFF            (0XAE)
#define DYNAMIC_DRIVE 		(0XA4)
#define DUTY_CYCLE             (0XA9)
#define CLOCKWISE_OUTPUT       (0XA0)
#define READ_MODIFY_WRITE_OFF  (0XEE)
#define START_COLUMN           (0X00)
#define START_LINE             (0XC0)
#define DISPLAY_ON             (0XAF)

#define PORT8_DIR_ADDR     (0x5800e400)
#define PORT8_MASK_ADDR    (0x5800e3fc)
#define PORT9_DIR_ADDR     (0x5800f400)
#define PORT9_MASK_ADDR    (0x5800f3fc)

///////////////////////////////////////////////////////////////////
extern unsigned char ucol;
extern unsigned char ulayer;
extern unsigned char mode;   //set the positive or negtive disply here

void LCD_Config ( void );
void LCD_Printf(unsigned char layer, unsigned char *ptr, ...);
void LCD_Ini ( void ); //lcd initialization
void ClrScr ( void );   //clear screen
char htoa_hi(unsigned char byte);  //hi_nibble(byte) to char
char htoa_lo(unsigned char byte); // lo_nibble(byte) to char

void DrawBmpP0( unsigned char x0,unsigned char layer,unsigned char width,unsigned char *bmp);
void DrawBmpP1( unsigned char x0,unsigned char layer,unsigned char width,unsigned char *bmp);
void DrawBmpP2( unsigned char x0,unsigned char layer,unsigned char width,unsigned char *bmp);
void DrawBmpP3( unsigned char x0,unsigned char layer,unsigned char width,unsigned char *bmp);
void DrawBmpSP0( unsigned char x0,unsigned char layer,unsigned char width,unsigned char *bmp);
void DrawBmpSP1( unsigned char x0,unsigned char layer,unsigned char width,unsigned char *bmp);
void DrawBmpSP2( unsigned char x0,unsigned char layer,unsigned char width,unsigned char *bmp);
void DrawBmpSP3( unsigned char x0,unsigned char layer,unsigned char width,unsigned char *bmp);


#endif
